/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.LinkedHashSet;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.property.PropertyKey;
import org.structr.schema.ConfigurationProvider;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class MergePropertiesFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_MERGE_PROPERTIES = "Usage: ${merge_properties(source, target , mergeKeys...)}. Example: ${merge_properties(this, parent, \"eMail\")}";

    @Override
    public String getName() {
        return "merge_properties()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (this.arrayHasMinLengthAndAllElementsNotNull(sources, 2) && sources[0] instanceof GraphObject && sources[1] instanceof GraphObject) {
            ConfigurationProvider config = StructrApp.getConfiguration();
            LinkedHashSet<PropertyKey> mergeKeys = new LinkedHashSet<PropertyKey>();
            GraphObject source = (GraphObject)sources[0];
            GraphObject target = (GraphObject)sources[1];
            int paramCount = sources.length;
            for (int i = 2; i < paramCount; ++i) {
                String keyName = sources[i].toString();
                PropertyKey key = config.getPropertyKeyForJSONName(target.getClass(), keyName);
                mergeKeys.add(key);
            }
            for (PropertyKey key : mergeKeys) {
                Object sourceValue = source.getProperty(key);
                if (sourceValue == null) continue;
                target.setProperty(key, sourceValue);
            }
        } else {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_MERGE_PROPERTIES;
    }

    @Override
    public String shortDescription() {
        return "";
    }
}

