/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class MergeUniqueFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_MERGE_UNIQUE = "Usage: ${merge_unique(list1, list2, list3, ...)}. Example: ${merge_unique(this.children, this.siblings)}";

    @Override
    public String getName() {
        return "merge_unique()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        for (Object source : sources) {
            if (source instanceof Collection) {
                for (Object obj : (Collection)source) {
                    if (obj == null) continue;
                    result.add(obj);
                }
                continue;
            }
            if (source == null) continue;
            result.add(source);
        }
        return new LinkedList(result);
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_MERGE_UNIQUE;
    }

    @Override
    public String shortDescription() {
        return "Merges the given collections / objects into a single collection, removing duplicates";
    }
}

