/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class MinFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_MIN = "Usage: ${min(value1, value2)}. Example: ${min(this.children, 5)}";

    @Override
    public String getName() {
        return "min()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 2)) {
                return null;
            }
            try {
                return Math.min(Double.parseDouble(sources[0].toString()), Double.parseDouble(sources[1].toString()));
            }
            catch (NumberFormatException nfe) {
                this.logException(nfe, "{}: NumberFormatException in element \"{}\" for parameters: {}", new Object[]{this.getName(), caller, this.getParametersAsString(sources)});
                return this.usage(ctx.isJavaScriptContext());
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_MIN;
    }

    @Override
    public String shortDescription() {
        return "Returns the smaller value of the given arguments";
    }
}

