/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class MultFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_MULT = "Usage: ${mult(value1, value2)}. Example: ${mult(5, 2)}";

    @Override
    public String getName() {
        return "mult()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        double result = 1.0;
        if (sources != null) {
            for (Object i : sources) {
                if (i == null) {
                    return null;
                }
                try {
                    result *= Double.parseDouble(i.toString());
                }
                catch (Throwable t) {
                    this.logException(caller, t, sources);
                    return t.getMessage();
                }
            }
        } else {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return result;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_MULT;
    }

    @Override
    public String shortDescription() {
        return "Multiplies the first argument by the second argument";
    }
}

