/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.List;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class NthFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_NTH = "Usage: ${nth(collection)}. Example: ${nth(this.children, 2)}";

    @Override
    public String getName() {
        return "nth()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            Object[] arr;
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 2)) {
                return null;
            }
            int pos = Double.valueOf(sources[1].toString()).intValue();
            if (sources[0] instanceof List && !((List)sources[0]).isEmpty()) {
                List list = (List)sources[0];
                int size = list.size();
                if (pos >= size) {
                    return null;
                }
                return list.get(Math.min(Math.max(0, pos), size - 1));
            }
            if (sources[0].getClass().isArray() && pos <= (arr = (Object[])sources[0]).length) {
                return arr[pos];
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return null;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_NTH;
    }

    @Override
    public String shortDescription() {
        return "Returns the element with the given index of the given collection";
    }
}

