/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class NumFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_NUM = "Usage: ${num(string)}. Example: ${num(this.numericalStringValue)}";

    @Override
    public String getName() {
        return "num()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasMinLengthAndAllElementsNotNull(sources, 1)) {
                return null;
            }
            try {
                return this.getDoubleOrNull(sources[0]);
            }
            catch (Throwable t) {
                this.logException(caller, t, sources);
                return null;
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_NUM;
    }

    @Override
    public String shortDescription() {
        return "Converts the given string to a floating-point number";
    }
}

