/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.api.graph.Direction;
import org.structr.api.graph.RelationshipType;
import org.structr.common.error.FrameworkException;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipFactory;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class OutgoingFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_OUTGOING = "Usage: ${outgoing(entity [, relType])}. Example: ${outgoing(this, 'PARENT_OF')}";
    public static final String ERROR_MESSAGE_OUTGOING_JS = "Usage: ${{Structr.outgoing(entity [, relType])}}. Example: ${{outgoing(Structr.this, 'PARENT_OF')}}";

    @Override
    public String getName() {
        return "outgoing()";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (this.arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(sources, 1, 2)) {
            RelationshipFactory factory = new RelationshipFactory(ctx.getSecurityContext());
            Object source = sources[0];
            if (source instanceof NodeInterface) {
                NodeInterface node = (NodeInterface)source;
                if (sources.length <= 1) return factory.bulkInstantiate(node.getNode().getRelationships(Direction.OUTGOING));
                Object relType = sources[1];
                if (relType == null || !(relType instanceof String)) return "";
                String relTypeName = (String)relType;
                return factory.bulkInstantiate(node.getNode().getRelationships(Direction.OUTGOING, RelationshipType.forName((String)relTypeName)));
            }
            logger.warn("Error: entity is not a node. Parameters: {}", (Object)this.getParametersAsString(sources));
            return "Error: entity is not a node.";
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_OUTGOING_JS : ERROR_MESSAGE_OUTGOING;
    }

    @Override
    public String shortDescription() {
        return "Returns the outgoing relationships of the given entity";
    }
}

