/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class ParseDateFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_PARSE_DATE = "Usage: ${parse_date(value, pattern)}. Example: ${parse_date(\"2014-01-01\", \"yyyy-MM-dd\")}";
    public static final String ERROR_MESSAGE_PARSE_DATE_JS = "Usage: ${{Structr.parseDate(value, pattern)}}. Example: ${{Structr.parseDate(\"2014-01-01\", \"yyyy-MM-dd\")}}";

    @Override
    public String getName() {
        return "parse_date()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (sources == null || sources.length != 2) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 2)) {
                return null;
            }
            String dateString = sources[0].toString();
            if (StringUtils.isBlank((CharSequence)dateString)) {
                return "";
            }
            String pattern = sources[1].toString();
            try {
                return new SimpleDateFormat(pattern).parse(dateString);
            }
            catch (ParseException ex) {
                this.logException(ex, "{}: Could not parse date and format it to pattern in element: \"{}\". Parameters: {}", new Object[]{this.getName(), caller, this.getParametersAsString(sources)});
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_PARSE_DATE_JS : ERROR_MESSAGE_PARSE_DATE;
    }

    @Override
    public String shortDescription() {
        return "Parses the given date string using the given format string";
    }
}

