/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.Map;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.schema.ConfigurationProvider;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class PrivilegedFindFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_PRIVILEGEDFIND = "Usage: ${find_privileged(type, key, value)}. Example: ${find_privileged(\"User\", \"email\", \"tester@test.com\"}";

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (sources != null) {
            SecurityContext securityContext = SecurityContext.getSuperUserInstance();
            ConfigurationProvider config = StructrApp.getConfiguration();
            Query<? extends NodeInterface> query = StructrApp.getInstance(securityContext).nodeQuery().sort(GraphObject.createdDate).order(false);
            Class type = null;
            if (sources.length >= 1 && sources[0] != null) {
                String typeString = sources[0].toString();
                type = config.getNodeEntityClass(typeString);
                if (type != null) {
                    query.andTypes(type);
                } else {
                    logger.warn("Error in find_privileged(): type \"{}\" not found.", (Object)typeString);
                    return "Error in find_privileged(): type " + typeString + " not found.";
                }
            }
            if (type == null) {
                logger.warn("Error in find_privileged(): no type specified. Parameters: {}", (Object)this.getParametersAsString(sources));
                return "Error in find_privileged(): no type specified.";
            }
            securityContext.ignoreResultCount(true);
            if (sources.length == 2 && sources[1] instanceof Map) {
                query.and(PropertyMap.inputTypeToJavaType(securityContext, type, (Map)sources[1]));
            } else {
                if (sources.length == 2) {
                    if (sources[1] == null) {
                        throw new IllegalArgumentException();
                    }
                    PropertyKey key = config.getPropertyKeyForJSONName(type, "id");
                    query.and(key, sources[1].toString());
                    int resultCount = query.getResult().size();
                    switch (resultCount) {
                        case 1: {
                            return query.getFirst();
                        }
                        case 0: {
                            return null;
                        }
                    }
                    throw new FrameworkException(400, "Multiple Objects found for id! [" + sources[1].toString() + "]");
                }
                int parameter_count = sources.length;
                if (parameter_count % 2 == 0) {
                    throw new FrameworkException(400, "Invalid number of parameters: " + parameter_count + ". Should be uneven: " + ERROR_MESSAGE_PRIVILEGEDFIND);
                }
                for (int c = 1; c < parameter_count; c += 2) {
                    PropertyKey key = config.getPropertyKeyForJSONName(type, sources[c].toString());
                    if (key == null) continue;
                    PropertyConverter inputConverter = key.inputConverter(securityContext);
                    Object value = sources[c + 1];
                    if (inputConverter != null) {
                        value = inputConverter.convert(value);
                    }
                    query.and(key, value);
                }
            }
            return query.getAsList();
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_PRIVILEGEDFIND;
    }

    @Override
    public String shortDescription() {
        return "Returns a collection of entities of the given type from the database, takes optional key/value pairs. Executed in a super user context.";
    }

    @Override
    public String getName() {
        return "find_privileged()";
    }
}

