/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class QuotFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_QUOT = "Usage: ${quot(value1, value2)}. Example: ${quot(5, 2)}";

    @Override
    public String getName() {
        return "quot()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (this.arrayHasLengthAndAllElementsNotNull(sources, 2)) {
                try {
                    return Double.parseDouble(sources[0].toString()) / Double.parseDouble(sources[1].toString());
                }
                catch (NumberFormatException nfe) {
                    this.logException(nfe, "{}: NumberFormatException in element \"{}\" for parameters: {}", new Object[]{this.getName(), caller, this.getParametersAsString(sources)});
                    return nfe.getMessage();
                }
            }
            if (sources.length > 0 && sources[0] != null) {
                try {
                    return Double.parseDouble(sources[0].toString());
                }
                catch (NumberFormatException nfe) {
                    this.logException(nfe, "{}: NumberFormatException in element \"{}\" for parameters: {}", new Object[]{this.getName(), caller, this.getParametersAsString(sources)});
                    return nfe.getMessage();
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return null;
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_QUOT;
    }

    @Override
    public String shortDescription() {
        return "Divides the first argument by the second argument";
    }
}

