/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.apache.commons.lang3.RandomStringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class RandomFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_RANDOM = "Usage: ${random(num)}. Example: ${set(this, \"password\", random(8))}";

    @Override
    public String getName() {
        return "random()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 1) || !(sources[0] instanceof Number)) {
                return null;
            }
            try {
                return RandomStringUtils.randomAlphanumeric((int)((Number)sources[0]).intValue());
            }
            catch (Throwable t) {
                this.logException(caller, t, sources);
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_RANDOM;
    }

    @Override
    public String shortDescription() {
        return "Returns a random alphanumeric string of the given length";
    }
}

