/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class ReadFunction
extends Function<Object, Object> {
    private static final Logger logger = LoggerFactory.getLogger((String)ReadFunction.class.getName());
    public static final String ERROR_MESSAGE_READ = "Usage: ${read(filename)}. Example: ${read(\"text.xml\")}";

    @Override
    public String getName() {
        return "read()";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 1)) {
                return null;
            }
            try {
                String sandboxFilename = this.getSandboxFileName(sources[0].toString());
                if (sandboxFilename == null) return "";
                File file = new File(sandboxFilename);
                if (!file.exists()) return "";
                if (file.length() >= 10000000L) return "";
                try (FileInputStream fis = new FileInputStream(file);){
                    String string = IOUtils.toString((InputStream)fis, (String)"utf-8");
                    return string;
                }
            }
            catch (IOException ioex) {
                this.logException(ioex, "{}: IOException in element \"{}\" for parameters: {}", new Object[]{this.getName(), caller, this.getParametersAsString(sources)});
                return "";
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_READ;
    }

    @Override
    public String shortDescription() {
        return "Reads and returns the contents of the given file from the exchange directoy";
    }
}

