/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.Permission;
import org.structr.common.Permissions;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Principal;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class RevokeFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_REVOKE = "Usage: ${revoke(principal, node, permissions)}. Example: ${revoke(me, this, 'write, delete'))}";
    public static final String ERROR_MESSAGE_REVOKE_JS = "Usage: ${{Structr.revoke(principal, node, permissions)}}. Example: ${{Structr.revoke(Structr.('me'), Structr.this, 'write, delete'))}}";

    @Override
    public String getName() {
        return "revoke()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 3)) {
                return null;
            }
            if (sources[0] instanceof Principal) {
                Principal principal = (Principal)sources[0];
                if (sources[1] instanceof AbstractNode) {
                    AbstractNode node = (AbstractNode)sources[1];
                    if (sources[2] instanceof String) {
                        String[] parts;
                        for (String part : parts = ((String)sources[2]).split("[,]+")) {
                            String trimmedPart = part.trim();
                            if (trimmedPart.length() <= 0) continue;
                            Permission permission = Permissions.valueOf(trimmedPart);
                            if (permission != null) {
                                node.revoke(permission, principal);
                                continue;
                            }
                            logger.warn("Error: unknown permission \"{}\". Parameters: {}", new Object[]{trimmedPart, this.getParametersAsString(sources)});
                            return "Error: unknown permission " + trimmedPart;
                        }
                        return "";
                    }
                    logger.warn("Error: third argument is not a string. Parameters: {}", (Object)this.getParametersAsString(sources));
                    return "Error: third argument is not a string.";
                }
                logger.warn("Error: second argument is not a node. Parameters: {}", (Object)this.getParametersAsString(sources));
                return "Error: second argument is not a node.";
            }
            logger.warn("Error: first argument is not of type Principal. Parameters: {}", (Object)this.getParametersAsString(sources));
            return "Error: first argument is not of type Principal.";
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_REVOKE_JS : ERROR_MESSAGE_REVOKE;
    }

    @Override
    public String shortDescription() {
        return "Revokes the given permissions on the given entity from a user";
    }
}

