/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.Random;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class RintFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_RINT = "Usage: ${rint(range)}. Example: ${rint(1000)}";

    @Override
    public String getName() {
        return "rint()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 1) || !(sources[0] instanceof Number)) {
                return null;
            }
            try {
                return new Random(System.currentTimeMillis()).nextInt(((Number)sources[0]).intValue());
            }
            catch (Throwable t) {
                this.logException(caller, t, sources);
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_RINT;
    }

    @Override
    public String shortDescription() {
        return "Returns a random integer in the given range";
    }
}

