/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.List;
import java.util.Map;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.function.QueryFunction;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.schema.ConfigurationProvider;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class SearchFunction
extends Function<Object, Object>
implements QueryFunction {
    public static final String ERROR_MESSAGE_SEARCH = "Usage: ${search(type, key, value)}. Example: ${search(\"User\", \"name\", \"abc\")}";
    public static final String ERROR_MESSAGE_SEARCH_JS = "Usage: ${{Structr.search(type, key, value)}}. Example: ${{Structr.search(\"User\", \"name\", \"abc\")}}";
    private int start = -1;
    private int end = -1;

    @Override
    public String getName() {
        return "search()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (sources != null) {
            SecurityContext securityContext = ctx.getSecurityContext();
            ConfigurationProvider config = StructrApp.getConfiguration();
            Query<? extends NodeInterface> query = StructrApp.getInstance(securityContext).nodeQuery();
            if (this.start >= 0 && this.end >= 0) {
                int pageSize = this.end - this.start;
                int page = this.start % pageSize;
                query.pageSize(pageSize);
                query.page(page);
            }
            Class type = null;
            if (sources.length >= 1 && sources[0] != null) {
                String typeString = sources[0].toString();
                type = config.getNodeEntityClass(typeString);
                if (type != null) {
                    query.andTypes(type);
                } else {
                    logger.warn("Error in search(): type {} not found.", (Object)typeString);
                    return "Error in search(): type " + typeString + " not found.";
                }
            }
            if (type == null) {
                logger.warn("Error in search(): no type specified. Parameters: {}", (Object)this.getParametersAsString(sources));
                return "Error in search(): no type specified.";
            }
            securityContext.ignoreResultCount(true);
            if (sources.length == 2 && sources[1] instanceof Map) {
                PropertyMap map = PropertyMap.inputTypeToJavaType(securityContext, type, (Map)sources[1]);
                for (Map.Entry<PropertyKey, Object> entry : map.entrySet()) {
                    query.and(entry.getKey(), entry.getValue(), false);
                }
            } else {
                int parameter_count = sources.length;
                if (parameter_count % 2 == 0) {
                    throw new FrameworkException(400, "Invalid number of parameters: " + parameter_count + ". Should be uneven: " + ERROR_MESSAGE_SEARCH);
                }
                for (int c = 1; c < parameter_count; c += 2) {
                    PropertyKey key = config.getPropertyKeyForJSONName(type, sources[c].toString());
                    if (key == null) continue;
                    PropertyConverter inputConverter = key.inputConverter(securityContext);
                    Object value = sources[c + 1];
                    if (inputConverter != null) {
                        value = inputConverter.convert(value);
                    }
                    query.and(key, value, false);
                }
            }
            List<? extends NodeInterface> x = query.getAsList();
            return x;
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return this.usage(ctx.isJavaScriptContext());
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_SEARCH_JS : ERROR_MESSAGE_SEARCH;
    }

    @Override
    public String shortDescription() {
        return "Returns a collection of entities of the given type from the database, takes optional key/value pairs. Searches case-insensitve / inexact.";
    }

    @Override
    public void setRangeStart(int start) {
        this.start = start;
    }

    @Override
    public void setRangeEnd(int end) {
        this.end = end;
    }
}

