/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class SetFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_SET = "Usage: ${set(entity, propertyKey, value)}. Example: ${set(this, \"email\", lower(this.email))}";

    @Override
    public String getName() {
        return "set()";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (this.arrayHasMinLengthAndAllElementsNotNull(sources, 2)) {
            if (!(sources[0] instanceof GraphObject)) throw new FrameworkException(422, "Invalid use of builtin method set, usage: set(entity, params..)");
            GraphObject source = (GraphObject)sources[0];
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            SecurityContext securityContext = ctx.getSecurityContext();
            source.setSecurityContext(securityContext);
            Gson gson = new GsonBuilder().create();
            Class<?> type = source.getClass();
            int sourceCount = sources.length;
            if (sources.length == 3 && sources[2] != null && sources[1].toString().matches("[a-zA-Z0-9_]+")) {
                properties.put(sources[1].toString(), sources[2]);
            } else {
                for (int i = 1; i < sourceCount; ++i) {
                    Map<String, Object> values = SetFunction.deserialize(gson, sources[i].toString());
                    if (values == null) continue;
                    properties.putAll(values);
                }
            }
            PropertyMap map = PropertyMap.inputTypeToJavaType(securityContext, type, properties);
            for (Map.Entry<PropertyKey, Object> entry : map.entrySet()) {
                source.setProperty(entry.getKey(), entry.getValue());
            }
            return "";
        } else {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_SET;
    }

    @Override
    public String shortDescription() {
        return "Sets a value on an entity";
    }
}

