/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.function.SetFunction;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class SetPrivilegedFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_SET_PRIVILEGED = "Usage: ${set_privileged(entity, propertyKey, value)}. Example: ${set_privileged(this, \"email\", lower(this.email))}";
    public static final String ERROR_MESSAGE_SET_PRIVILEGED_JS = "Usage: ${{Structr.setPrvileged(entity, propertyKey, value)}}. Example: ${{Structr.setPrivileged(Structr.this, \"email\", lower(Structr.this.email))}}";

    @Override
    public String getName() {
        return "set_privileged()";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        ActionContext actionContext = ctx;
        synchronized (actionContext) {
            SecurityContext previousSecurityContext = ctx.getSecurityContext();
            ctx.setSecurityContext(SecurityContext.getSuperUserInstance());
            try {
                SetFunction set = new SetFunction();
                set.apply(ctx, caller, sources);
            }
            finally {
                ctx.setSecurityContext(previousSecurityContext);
            }
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_SET_PRIVILEGED_JS : ERROR_MESSAGE_SET_PRIVILEGED;
    }

    @Override
    public String shortDescription() {
        return "Sets the given key/value pair on the given entity with super-user privileges";
    }
}

