/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.structr.common.GraphObjectComparator;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.property.PropertyKey;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class SortFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_SORT = "Usage: ${sort(list1, [key [, descending=false]])}. Example: ${sort(this.children, \"name\")}";

    @Override
    public String getName() {
        return "sort()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (sources == null || sources.length == 0) {
            return null;
        }
        String sortKey = "name";
        if (sources.length > 1 && sources[1] instanceof String) {
            sortKey = (String)sources[1];
        }
        if (sources.length >= 1) {
            List list;
            Iterator iterator;
            if (sources[0] instanceof List && (iterator = (list = (List)sources[0]).iterator()).hasNext()) {
                Object firstElement = iterator.next();
                if (firstElement instanceof GraphObject) {
                    boolean descending;
                    Class<?> type = firstElement.getClass();
                    PropertyKey key = StructrApp.getConfiguration().getPropertyKeyForJSONName(type, sortKey);
                    boolean bl = descending = sources.length == 3 && sources[2] != null && "true".equals(sources[2].toString());
                    if (key != null) {
                        List sortCollection = list;
                        Collections.sort(sortCollection, new GraphObjectComparator(key, descending));
                        return sortCollection;
                    }
                } else if (firstElement instanceof String) {
                    Object[] stringArray = list.toArray(new String[list.size()]);
                    Arrays.sort(stringArray);
                    return Arrays.asList(stringArray);
                }
            }
        } else {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        }
        return sources[0];
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_SORT;
    }

    @Override
    public String shortDescription() {
        return "Sorts the given collection or array according to the given property key. Default sort key is 'name'.";
    }
}

