/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.Arrays;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class SplitRegexFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_SPLIT_REGEX = "Usage: ${split_regex(value)}. Example: ${split_regex('foo|bar', '|')}";

    @Override
    public String getName() {
        return "split_regex()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (this.arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(sources, 1, 2)) {
            String toSplit = sources[0].toString();
            String splitExpr = "[,;\\s]+";
            if (sources.length >= 2) {
                splitExpr = sources[1].toString();
            }
            return Arrays.asList(toSplit.split(splitExpr));
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_SPLIT_REGEX;
    }

    @Override
    public String shortDescription() {
        return "Splits the given string by given regex";
    }
}

