/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.MailTemplate;
import org.structr.core.script.Scripting;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class TemplateFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_TEMPLATE = "Usage: ${template(name, locale, source)}. Example: ${template(\"TEXT_TEMPLATE_1\", \"en_EN\", this)}";
    public static final String ERROR_MESSAGE_TEMPLATE_JS = "Usage: ${{Structr.template(name, locale, source)}}. Example: ${{Structr.template(\"TEXT_TEMPLATE_1\", \"en_EN\", Structr.get('this'))}}";

    @Override
    public String getName() {
        return "template()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (sources == null || sources != null && sources.length != 3) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 3) || !(sources[2] instanceof GraphObject)) {
                return null;
            }
            App app = StructrApp.getInstance(ctx.getSecurityContext());
            String name = sources[0].toString();
            String locale = sources[1].toString();
            MailTemplate template = app.nodeQuery(MailTemplate.class).andName(name).and(MailTemplate.locale, locale).getFirst();
            GraphObject templateInstance = (GraphObject)sources[2];
            if (template != null) {
                String text = template.getProperty(MailTemplate.text);
                if (text != null) {
                    return Scripting.replaceVariables(ctx, templateInstance, text);
                }
            } else {
                logger.warn("No MailTemplate found for parameters: {}", (Object)this.getParametersAsString(sources));
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return "";
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_TEMPLATE_JS : ERROR_MESSAGE_TEMPLATE;
    }

    @Override
    public String shortDescription() {
        return "Returns a MailTemplate object with the given name, replaces the placeholders with values from the given entity";
    }
}

