/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import java.util.Date;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class TimerFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_TIMER = "Usage: ${timer(name, action)}. Example: ${timer('benchmark1', 'start')}";
    public static final String ERROR_MESSAGE_TIMER_JS = "Usage: ${{Structr.timer(name, action)}}. Example: ${{Structr.timer('benchmark1', 'start')}}";

    @Override
    public String getName() {
        return "timer()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (sources.length == 2 && sources[0] instanceof String && sources[1] instanceof String) {
            String name = sources[0].toString();
            String action = sources[1].toString();
            if (action.equals("start")) {
                ctx.addTimer(name);
                return null;
            }
            if (action.equals("get")) {
                Date begin = ctx.getTimer(name);
                if (begin == null) {
                    logger.warn("Timer {} has not been started yet. Starting it.", (Object)name);
                    ctx.addTimer(name);
                    return 0;
                }
                return new Date().getTime() - begin.getTime();
            }
            logger.warn("Unknown action for timer function: {}", (Object)action);
        } else {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        }
        return this.usage(ctx.isJavaScriptContext());
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_TIMER_JS : ERROR_MESSAGE_TIMER;
    }

    @Override
    public String shortDescription() {
        return "Starts/Stops/Pings a timer";
    }
}

