/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class TitleizeFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_TITLEIZE = "Usage: ${titleize(string, separator}. (Default separator is \" \") Example: ${titleize(this.lowerCamelCaseString, \"_\")}";

    @Override
    public String getName() {
        return "titleize()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (sources == null || sources.length == 0 || sources.length > 0 && sources[0] == null || sources.length > 0 && sources[0] != null && StringUtils.isBlank((CharSequence)sources[0].toString())) {
            return "";
        }
        if (sources.length > 2) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        String separator = sources.length == 1 ? " " : sources[1].toString();
        String[] in = StringUtils.split((String)sources[0].toString(), (String)separator);
        Object[] out = new String[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = StringUtils.capitalize((String)in[i]);
        }
        return StringUtils.join((Object[])out, (String)" ");
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_TITLEIZE;
    }

    @Override
    public String shortDescription() {
        return "Titleizes the given string";
    }
}

