/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class UnlicensedFunction
extends Function<Object, Object> {
    private static final Logger logger = LoggerFactory.getLogger(UnlicensedFunction.class);
    private String name = null;
    private int edition = 1;

    public UnlicensedFunction(String name, int edition) {
        this.name = name;
        this.edition = edition;
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        throw new UnlicensedException(this.name, this.edition);
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return new UnlicensedException(this.name, this.edition).buildLogMessage();
    }

    @Override
    public String shortDescription() {
        return "Placeholder for unlicensed functions";
    }

    @Override
    public String getName() {
        return "unlicensed";
    }
}

