/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.function;

import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class UrlEncodeFunction
extends Function<Object, Object> {
    public static final String ERROR_MESSAGE_URLENCODE = "Usage: ${urlencode(string)}. Example: ${urlencode(this.email)}";

    @Override
    public String getName() {
        return "urlencode()";
    }

    @Override
    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 1)) {
                return null;
            }
            return this.encodeURL(sources[0].toString());
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    @Override
    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_URLENCODE;
    }

    @Override
    public String shortDescription() {
        return "URL-encodes the given string";
    }
}

