/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.api.util.Iterables;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.graph.BulkGraphOperation;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.RelationshipFactory;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;

public class BulkCopyRelationshipPropertyCommand
extends NodeServiceCommand
implements MaintenanceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)BulkCopyRelationshipPropertyCommand.class.getName());

    @Override
    public void execute(Map<String, Object> map) throws FrameworkException {
        DatabaseService graphDb = (DatabaseService)this.arguments.get("graphDb");
        RelationshipFactory relFactory = new RelationshipFactory(this.securityContext);
        final String sourceKey = (String)map.get("sourceKey");
        final String destKey = (String)map.get("destKey");
        if (sourceKey == null || destKey == null) {
            throw new IllegalArgumentException("This command requires one argument of type Map. Map must contain values for 'sourceKey' and 'destKey'.");
        }
        if (graphDb != null) {
            Iterator relIterator = null;
            try (Tx tx = StructrApp.getInstance().tx();){
                relIterator = Iterables.map(relFactory, (Iterable)graphDb.getAllRelationships()).iterator();
                tx.success();
            }
            long count = this.bulkGraphOperation(this.securityContext, relIterator, 1000L, "CopyRelationshipProperties", new BulkGraphOperation<AbstractRelationship>(){

                @Override
                public void handleGraphObject(SecurityContext securityContext, AbstractRelationship rel) {
                    if (rel.getProperty(GraphObject.id) != null) {
                        Class<?> type = rel.getClass();
                        PropertyKey destPropertyKey = StructrApp.getConfiguration().getPropertyKeyForDatabaseName(type, destKey);
                        PropertyKey sourcePropertyKey = StructrApp.getConfiguration().getPropertyKeyForDatabaseName(type, sourceKey);
                        try {
                            rel.setProperty(destPropertyKey, rel.getProperty(sourcePropertyKey));
                        }
                        catch (FrameworkException fex) {
                            logger.warn("Unable to copy relationship property {} of relationship {} to {}: {}", new Object[]{sourcePropertyKey, rel.getUuid(), destPropertyKey, fex.getMessage()});
                        }
                    }
                }

                @Override
                public void handleThrowable(SecurityContext securityContext, Throwable t, AbstractRelationship rel) {
                    logger.warn("Unable to copy relationship properties of relationship {}: {}", new Object[]{rel.getUuid(), t.getMessage()});
                }

                @Override
                public void handleTransactionFailure(SecurityContext securityContext, Throwable t) {
                    logger.warn("Unable to copy relationship properties: {}", (Object)t.getMessage());
                }
            });
            logger.info("Finished setting properties on {} nodes", (Object)count);
        }
    }

    @Override
    public boolean requiresEnclosingTransaction() {
        return false;
    }

    @Override
    public boolean requiresFlushingOfCaches() {
        return false;
    }
}

