/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.Permission;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.BulkGraphOperation;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.RelationshipInterface;

public class BulkDeleteCommand
extends NodeServiceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)BulkDeleteCommand.class.getName());

    public void bulkDelete(Iterator<GraphObject> iterator) throws FrameworkException {
        final App app = StructrApp.getInstance(this.securityContext);
        long count = this.bulkGraphOperation(this.securityContext, iterator, 1000L, "DeleteObjects", new BulkGraphOperation<GraphObject>(){

            @Override
            public void handleGraphObject(SecurityContext securityContext, GraphObject obj) {
                try {
                    if (obj.isNode()) {
                        AbstractNode node = (AbstractNode)obj;
                        if (!node.isGranted(Permission.delete, securityContext)) {
                            logger.warn("Could not delete {} because {} has no delete permission", (Object)obj.getUuid(), (Object)securityContext.getUser(false));
                        } else {
                            app.delete((NodeInterface)obj);
                        }
                    } else {
                        app.delete((RelationshipInterface)obj);
                    }
                }
                catch (FrameworkException fex) {
                    logger.warn("Unable to delete node {}: {}", (Object)obj.getUuid(), (Object)fex.toString());
                }
            }

            @Override
            public void handleThrowable(SecurityContext securityContext, Throwable t, GraphObject node) {
                logger.warn("Unable to delete node {}", (Object)node.getUuid());
            }

            @Override
            public void handleTransactionFailure(SecurityContext securityContext, Throwable t) {
                logger.warn("Unable to delete nodes {}", (Object)t.toString());
            }
        });
        this.info("Done with deleting {} nodes", count);
    }
}

