/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.api.util.Iterables;
import org.structr.common.SecurityContext;
import org.structr.common.StructrAndSpatialPredicate;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.BulkGraphOperation;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeFactory;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.Tx;

public class BulkDeleteSoftDeletedNodesCommand
extends NodeServiceCommand
implements MaintenanceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)BulkDeleteSoftDeletedNodesCommand.class.getName());

    @Override
    public void execute(Map<String, Object> properties) throws FrameworkException {
        DatabaseService graphDb = (DatabaseService)this.arguments.get("graphDb");
        SecurityContext superUserContext = SecurityContext.getSuperUserInstance();
        NodeFactory nodeFactory = new NodeFactory(superUserContext, true, false);
        if (graphDb != null) {
            Iterator nodeIterator = null;
            try (Tx tx = StructrApp.getInstance().tx();){
                nodeIterator = Iterables.map(nodeFactory, (Iterable)Iterables.filter(new StructrAndSpatialPredicate(true, false, false), (Iterable)graphDb.getAllNodes())).iterator();
                tx.success();
            }
            final boolean erase = properties.containsKey("erase") && properties.get("erase").equals("true");
            this.bulkGraphOperation(this.securityContext, nodeIterator, 1000L, "DeleteSoftDeletedNodes", new BulkGraphOperation<AbstractNode>(){

                @Override
                public void handleGraphObject(SecurityContext securityContext, AbstractNode node) {
                    if (node.isDeleted()) {
                        logger.info("Found deleted node: {}", (Object)node);
                        if (erase) {
                            try {
                                StructrApp.getInstance(securityContext).delete(node);
                            }
                            catch (FrameworkException ex) {
                                logger.warn("Could not delete node " + node, (Throwable)ex);
                            }
                        }
                    }
                }

                @Override
                public void handleThrowable(SecurityContext securityContext, Throwable t, AbstractNode node) {
                    logger.warn("Unable to set properties of node {}: {}", new Object[]{node.getUuid(), t.getMessage()});
                }

                @Override
                public void handleTransactionFailure(SecurityContext securityContext, Throwable t) {
                    logger.warn("Unable to set node properties: {}", (Object)t.getMessage());
                }
            });
        }
        logger.info("Done");
    }

    @Override
    public boolean requiresEnclosingTransaction() {
        return false;
    }

    @Override
    public boolean requiresFlushingOfCaches() {
        return false;
    }
}

