/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.api.util.Iterables;
import org.structr.common.SecurityContext;
import org.structr.common.StructrAndSpatialPredicate;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.graph.BulkGraphOperation;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeFactory;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.RelationshipFactory;
import org.structr.core.graph.TransactionPostProcess;
import org.structr.core.graph.Tx;

public class BulkRebuildIndexCommand
extends NodeServiceCommand
implements MaintenanceCommand,
TransactionPostProcess {
    private static final Logger logger = LoggerFactory.getLogger((String)BulkRebuildIndexCommand.class.getName());

    @Override
    public void execute(Map<String, Object> attributes) {
        String mode = (String)attributes.get("mode");
        String entityType = (String)attributes.get("type");
        String relType = (String)attributes.get("relType");
        if (mode == null || "nodesOnly".equals(mode)) {
            this.rebuildNodeIndex(entityType);
        }
        if (mode == null || "relsOnly".equals(mode)) {
            this.rebuildRelationshipIndex(relType);
        }
    }

    @Override
    public boolean execute(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        this.execute(Collections.EMPTY_MAP);
        return true;
    }

    @Override
    public boolean requiresEnclosingTransaction() {
        return false;
    }

    @Override
    public boolean requiresFlushingOfCaches() {
        return false;
    }

    private void rebuildNodeIndex(String entityType) {
        NodeFactory nodeFactory = new NodeFactory(SecurityContext.getSuperUserInstance());
        DatabaseService graphDb = (DatabaseService)this.arguments.get("graphDb");
        Iterator nodeIterator = null;
        try (Tx tx = StructrApp.getInstance().tx();){
            nodeIterator = Iterables.map(nodeFactory, (Iterable)Iterables.filter(new StructrAndSpatialPredicate(true, false, false), (Iterable)graphDb.getNodesByTypeProperty(entityType))).iterator();
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("Exception while creating all nodes iterator.", (Throwable)fex);
        }
        if (entityType == null) {
            this.info("Node type not set or no entity class found. Starting (re-)indexing all nodes", new Object[0]);
        } else {
            this.info("Starting (re-)indexing all nodes of type {}", entityType);
        }
        long count = this.bulkGraphOperation(this.securityContext, nodeIterator, 1000L, "RebuildNodeIndex", new BulkGraphOperation<AbstractNode>(){

            @Override
            public void handleGraphObject(SecurityContext securityContext, AbstractNode node) {
                node.updateInIndex();
            }

            @Override
            public void handleThrowable(SecurityContext securityContext, Throwable t, AbstractNode node) {
                logger.warn("Unable to index node {}: {}", new Object[]{node, t.getMessage()});
            }

            @Override
            public void handleTransactionFailure(SecurityContext securityContext, Throwable t) {
                logger.warn("Unable to index node: {}", (Object)t.getMessage());
            }
        });
        this.info("Done with (re-)indexing {} nodes", count);
    }

    private void rebuildRelationshipIndex(String relType) {
        RelationshipFactory relFactory = new RelationshipFactory(SecurityContext.getSuperUserInstance());
        DatabaseService graphDb = (DatabaseService)this.arguments.get("graphDb");
        Iterator relIterator = null;
        try (Tx tx = StructrApp.getInstance().tx();){
            relIterator = Iterables.map(relFactory, (Iterable)Iterables.filter(new StructrAndSpatialPredicate(true, false, false), (Iterable)graphDb.getRelationshipsByType(relType))).iterator();
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("Exception while creating all relationships iterator.", (Throwable)fex);
        }
        if (relType == null) {
            this.info("Relationship type not set, starting (re-)indexing all relationships", new Object[0]);
        } else {
            this.info("Starting (re-)indexing all relationships of type {}", relType);
        }
        long count = this.bulkGraphOperation(this.securityContext, relIterator, 1000L, "RebuildRelIndex", new BulkGraphOperation<AbstractRelationship>(){

            @Override
            public void handleGraphObject(SecurityContext securityContext, AbstractRelationship rel) {
                rel.updateInIndex();
            }

            @Override
            public void handleThrowable(SecurityContext securityContext, Throwable t, AbstractRelationship rel) {
                logger.warn("Unable to index relationship {}: {}", new Object[]{rel, t.getMessage()});
            }

            @Override
            public void handleTransactionFailure(SecurityContext securityContext, Throwable t) {
                logger.warn("Unable to index relationship: {}", (Object)t.getMessage());
            }
        });
        this.info("Done with (re-)indexing {} relationships", count);
    }
}

