/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.api.util.Iterables;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.BulkGraphOperation;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeFactory;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.schema.SchemaHelper;

public class BulkSetNodePropertiesCommand
extends NodeServiceCommand
implements MaintenanceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)BulkSetNodePropertiesCommand.class.getName());

    @Override
    public void execute(final Map<String, Object> properties) throws FrameworkException {
        DatabaseService graphDb = (DatabaseService)this.arguments.get("graphDb");
        SecurityContext superUserContext = SecurityContext.getSuperUserInstance();
        NodeFactory nodeFactory = new NodeFactory(superUserContext);
        String type = (String)properties.get("type");
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new FrameworkException(422, "Type must not be empty");
        }
        final Class cls = SchemaHelper.getEntityClassForRawType(type);
        if (cls == null) {
            throw new FrameworkException(422, "Invalid type " + type);
        }
        if (graphDb != null) {
            Tx tx;
            Iterator nodeIterator = null;
            if (properties.containsKey(AbstractNode.type.dbName())) {
                tx = StructrApp.getInstance().tx();
                Throwable throwable = null;
                try {
                    nodeIterator = StructrApp.getInstance(this.securityContext).nodeQuery(cls).getResult().getResults().iterator();
                    tx.success();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
                properties.remove(AbstractNode.type.dbName());
            } else {
                tx = StructrApp.getInstance().tx();
                Throwable throwable = null;
                try {
                    nodeIterator = Iterables.map(nodeFactory, (Iterable)graphDb.getAllNodes()).iterator();
                    tx.success();
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            properties.remove("type");
            long count = this.bulkGraphOperation(this.securityContext, nodeIterator, 1000L, "SetNodeProperties", new BulkGraphOperation<AbstractNode>(){

                @Override
                public void handleGraphObject(SecurityContext securityContext, AbstractNode node) {
                    if (node.getProperty(GraphObject.id) != null) {
                        for (Map.Entry entry : properties.entrySet()) {
                            PropertyKey propertyKey;
                            PropertyConverter inputConverter;
                            String key = (String)entry.getKey();
                            Object val = null;
                            if (key.equals("newType")) {
                                key = "type";
                            }
                            if ((inputConverter = StructrApp.getConfiguration().getPropertyKeyForJSONName(cls, key).inputConverter(securityContext)) != null) {
                                try {
                                    val = inputConverter.convert(entry.getValue());
                                }
                                catch (FrameworkException ex) {
                                    logger.error("", (Throwable)ex);
                                }
                            } else {
                                val = entry.getValue();
                            }
                            if ((propertyKey = StructrApp.getConfiguration().getPropertyKeyForDatabaseName(node.getClass(), key)) == null) continue;
                            try {
                                node.unlockSystemPropertiesOnce();
                                node.setProperty(propertyKey, val);
                            }
                            catch (FrameworkException fex) {
                                logger.warn("Unable to set node property {} of node {} to {}: {}", new Object[]{propertyKey, node.getUuid(), val, fex.getMessage()});
                            }
                        }
                    }
                }

                @Override
                public void handleThrowable(SecurityContext securityContext, Throwable t, AbstractNode node) {
                    logger.warn("Unable to set properties of node {}: {}", new Object[]{node.getUuid(), t.getMessage()});
                }

                @Override
                public void handleTransactionFailure(SecurityContext securityContext, Throwable t) {
                    logger.warn("Unable to set node properties: {}", (Object)t.getMessage());
                }
            });
            logger.info("Fixed {} nodes ...", (Object)count);
        }
        logger.info("Done");
    }

    @Override
    public boolean requiresEnclosingTransaction() {
        return false;
    }

    @Override
    public boolean requiresFlushingOfCaches() {
        return false;
    }
}

