/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.api.util.Iterables;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.graph.BulkGraphOperation;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.RelationshipFactory;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.schema.SchemaHelper;

public class BulkSetRelationshipPropertiesCommand
extends NodeServiceCommand
implements MaintenanceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)BulkSetRelationshipPropertiesCommand.class.getName());

    @Override
    public void execute(final Map<String, Object> properties) throws FrameworkException {
        DatabaseService graphDb = (DatabaseService)this.arguments.get("graphDb");
        RelationshipFactory relationshipFactory = new RelationshipFactory(this.securityContext);
        if (graphDb != null) {
            Tx tx;
            Iterator relIterator = null;
            String typeName = "type";
            if (properties.containsKey("type")) {
                tx = StructrApp.getInstance().tx();
                Throwable throwable = null;
                try {
                    relIterator = StructrApp.getInstance(this.securityContext).relationshipQuery(SchemaHelper.getEntityClassForRawType("type")).getAsList().iterator();
                    tx.success();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
                properties.remove("type");
            } else {
                tx = StructrApp.getInstance().tx();
                Throwable throwable = null;
                try {
                    relIterator = Iterables.map(relationshipFactory, (Iterable)graphDb.getAllRelationships()).iterator();
                    tx.success();
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            long count = this.bulkGraphOperation(this.securityContext, relIterator, 1000L, "SetRelationshipProperties", new BulkGraphOperation<AbstractRelationship>(){

                @Override
                public void handleGraphObject(SecurityContext securityContext, AbstractRelationship rel) {
                    if (rel.getProperty(AbstractRelationship.id) != null) {
                        for (Map.Entry entry : properties.entrySet()) {
                            String key = (String)entry.getKey();
                            Object val = entry.getValue();
                            PropertyKey propertyKey = StructrApp.getConfiguration().getPropertyKeyForDatabaseName(rel.getClass(), key);
                            if (propertyKey == null) continue;
                            try {
                                rel.setProperty(propertyKey, val);
                            }
                            catch (FrameworkException fex) {
                                logger.warn("Unable to set relationship property {} of relationship {} to {}: {}", new Object[]{propertyKey, rel.getUuid(), val, fex.getMessage()});
                            }
                        }
                    }
                }

                @Override
                public void handleThrowable(SecurityContext securityContext, Throwable t, AbstractRelationship rel) {
                    logger.warn("Unable to set properties of relationship {}: {}", new Object[]{rel.getUuid(), t.getMessage()});
                }

                @Override
                public void handleTransactionFailure(SecurityContext securityContext, Throwable t) {
                    logger.warn("Unable to set relationship properties: {}", (Object)t.getMessage());
                }
            });
            logger.info("Finished setting properties on {} relationships", (Object)count);
        }
    }

    @Override
    public boolean requiresEnclosingTransaction() {
        return false;
    }

    @Override
    public boolean requiresFlushingOfCaches() {
        return false;
    }
}

