/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.structr.api.DatabaseService;
import org.structr.api.NativeResult;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.common.Permission;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Transformation;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.entity.Principal;
import org.structr.core.entity.Security;
import org.structr.core.entity.SuperUser;
import org.structr.core.entity.relationship.PrincipalOwnsNode;
import org.structr.core.graph.CreationContainer;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeFactory;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.TransactionCommand;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.TypeProperty;
import org.structr.schema.SchemaHelper;

public class CreateNodeCommand<T extends NodeInterface>
extends NodeServiceCommand {
    public T execute(Collection<NodeAttribute<?>> attributes) throws FrameworkException {
        PropertyMap properties = new PropertyMap();
        for (NodeAttribute<?> attribute : attributes) {
            properties.put(attribute.getKey(), attribute.getValue());
        }
        return this.execute(properties);
    }

    public T execute(NodeAttribute<?> ... attributes) throws FrameworkException {
        PropertyMap properties = new PropertyMap();
        for (NodeAttribute<?> attribute : attributes) {
            properties.put(attribute.getKey(), attribute.getValue());
        }
        return this.execute(properties);
    }

    public T execute(PropertyMap attributes) throws FrameworkException {
        DatabaseService graphDb = (DatabaseService)this.arguments.get("graphDb");
        Principal user = this.securityContext.getUser(false);
        NodeInterface node = null;
        if (graphDb != null) {
            NodeFactory nodeFactory = new NodeFactory(this.securityContext);
            PropertyMap properties = new PropertyMap(attributes);
            Object typeObject = properties.get(AbstractNode.type);
            Class nodeType = this.getTypeOrGeneric(typeObject);
            Set<String> labels = TypeProperty.getLabelsForType(nodeType);
            CreationContainer tmp = new CreationContainer();
            Date now = new Date();
            boolean isCreation = true;
            String uuid = properties.get(GraphObject.id);
            if (uuid == null) {
                uuid = CreateNodeCommand.getNextUuid();
                properties.put(GraphObject.id, uuid);
            }
            GraphObject.id.setProperty(this.securityContext, tmp, uuid);
            GraphObject.type.setProperty(this.securityContext, tmp, nodeType.getSimpleName());
            AbstractNode.createdDate.setProperty(this.securityContext, tmp, now);
            AbstractNode.lastModifiedDate.setProperty(this.securityContext, tmp, now);
            AbstractNode.visibleToPublicUsers.setProperty(this.securityContext, tmp, false);
            AbstractNode.visibleToAuthenticatedUsers.setProperty(this.securityContext, tmp, false);
            AbstractNode.hidden.setProperty(this.securityContext, tmp, false);
            AbstractNode.deleted.setProperty(this.securityContext, tmp, false);
            if (user != null) {
                String userId = user.getProperty(GraphObject.id);
                AbstractNode.createdBy.setProperty(this.securityContext, tmp, userId);
                AbstractNode.lastModifiedBy.setProperty(this.securityContext, tmp, userId);
            }
            properties.remove(AbstractNode.id);
            properties.remove(AbstractNode.type);
            properties.remove(AbstractNode.lastModifiedDate);
            properties.remove(AbstractNode.lastModifiedBy);
            properties.remove(AbstractNode.createdDate);
            properties.remove(AbstractNode.createdBy);
            node = nodeFactory.instantiateWithType(this.createNode(graphDb, user, nodeType, labels, tmp.getData()), nodeType, (Relationship)null, true);
            if (node != null) {
                TransactionCommand.nodeCreated(user, node);
                node.setProperties(this.securityContext, properties);
                properties.clear();
                node.addToIndex();
                StructrApp.invalidate(uuid);
            }
        }
        if (node != null) {
            node.onNodeCreation();
            Set<Transformation<GraphObject>> transformations = StructrApp.getConfiguration().getEntityCreationTransformations(node.getClass());
            for (Transformation<GraphObject> transformation : transformations) {
                transformation.apply(this.securityContext, node);
            }
        }
        return (T)node;
    }

    private Node createNode(DatabaseService graphDb, Principal user, Class nodeType, Set<String> labels, Map<String, Object> properties) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, String> ownsProperties = new HashMap<String, String>();
        HashMap<String, Object> securityProperties = new HashMap<String, Object>();
        StringBuilder buf = new StringBuilder();
        String newUuid = (String)properties.get("id");
        if (user != null && !(user instanceof SuperUser)) {
            buf.append("MATCH (u:Principal) WHERE id(u) = {userId}");
            buf.append(" CREATE (u)-[o:OWNS {ownsProperties}]->(n");
            for (String label : labels) {
                buf.append(":");
                buf.append(label);
            }
            buf.append(" {nodeProperties})<-[s:SECURITY {securityProperties}]-(u)");
            buf.append(" RETURN n");
            ownsProperties.put(GraphObject.id.dbName(), CreateNodeCommand.getNextUuid());
            ownsProperties.put(GraphObject.type.dbName(), PrincipalOwnsNode.class.getSimpleName());
            ownsProperties.put(AbstractRelationship.sourceId.dbName(), user.getUuid());
            ownsProperties.put(AbstractRelationship.targetId.dbName(), newUuid);
            securityProperties.put(Security.allowed.dbName(), new String[]{Permission.read.name(), Permission.write.name(), Permission.delete.name(), Permission.accessControl.name()});
            securityProperties.put(GraphObject.id.dbName(), CreateNodeCommand.getNextUuid());
            securityProperties.put(GraphObject.type.dbName(), Security.class.getSimpleName());
            securityProperties.put(AbstractRelationship.sourceId.dbName(), user.getUuid());
            securityProperties.put(AbstractRelationship.targetId.dbName(), newUuid);
            parameters.put("userId", user.getId());
            parameters.put("ownsProperties", ownsProperties);
            parameters.put("securityProperties", securityProperties);
        } else {
            buf.append("CREATE (n");
            for (String label : labels) {
                buf.append(":");
                buf.append(label);
            }
            buf.append(" {nodeProperties})");
            buf.append(" RETURN n");
        }
        parameters.put("nodeProperties", properties);
        NativeResult result = graphDb.execute(buf.toString(), parameters);
        if (result.hasNext()) {
            Map data = result.next();
            Node newNode = (Node)data.get("n");
            return newNode;
        }
        throw new RuntimeException("Unable to create new node.");
    }

    private Class getTypeOrGeneric(Object typeObject) {
        if (typeObject != null) {
            return SchemaHelper.getEntityClassForRawType(typeObject.toString());
        }
        return StructrApp.getConfiguration().getFactoryDefinition().getGenericNodeType();
    }
}

