/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Transformation;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.entity.Relation;
import org.structr.core.graph.CreationContainer;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.RelationshipFactory;
import org.structr.core.graph.TransactionCommand;
import org.structr.core.property.PropertyMap;

public class CreateRelationshipCommand
extends NodeServiceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)CreateRelationshipCommand.class.getName());

    public <A extends NodeInterface, B extends NodeInterface, R extends Relation<A, B, ?, ?>> R execute(A fromNode, B toNode, Class<R> relType) throws FrameworkException {
        return this.createRelationship(fromNode, toNode, relType, null);
    }

    public <A extends NodeInterface, B extends NodeInterface, R extends Relation<A, B, ?, ?>> R execute(A fromNode, B toNode, Class<R> relType, PropertyMap properties) throws FrameworkException {
        return this.createRelationship(fromNode, toNode, relType, properties);
    }

    private synchronized <A extends NodeInterface, B extends NodeInterface, R extends Relation<A, B, ?, ?>> R createRelationship(A fromNode, B toNode, Class<R> relType, PropertyMap attributes) throws FrameworkException {
        this.securityContext.preventModificationOfAccessTime();
        RelationshipFactory<R> factory = new RelationshipFactory<R>(this.securityContext);
        PropertyMap properties = new PropertyMap(attributes);
        CreationContainer tmp = new CreationContainer();
        R template = this.instantiate(relType);
        Node startNode = fromNode.getNode();
        Node endNode = toNode.getNode();
        Date now = new Date();
        template.ensureCardinality(this.securityContext, fromNode, toNode);
        AbstractRelationship.createdDate.setProperty(this.securityContext, tmp, now);
        AbstractRelationship.createdDate.setProperty(this.securityContext, tmp, now);
        AbstractRelationship.lastModifiedDate.setProperty(this.securityContext, tmp, now);
        tmp.getData().put(GraphObject.id.jsonName(), CreateRelationshipCommand.getNextUuid());
        tmp.getData().put(GraphObject.type.jsonName(), relType.getSimpleName());
        tmp.getData().put(AbstractRelationship.relType.jsonName(), template.name());
        tmp.getData().put(AbstractRelationship.sourceId.jsonName(), fromNode.getUuid());
        tmp.getData().put(AbstractRelationship.targetId.jsonName(), toNode.getUuid());
        tmp.getData().put(AbstractRelationship.visibleToPublicUsers.jsonName(), false);
        tmp.getData().put(AbstractRelationship.visibleToAuthenticatedUsers.jsonName(), false);
        tmp.getData().put(AbstractRelationship.cascadeDelete.jsonName(), template.getCascadingDeleteFlag());
        Relationship rel = startNode.createRelationshipTo(endNode, template, tmp.getData());
        Relation newRel = (Relation)factory.instantiateWithType(rel, relType, (Relationship)null, true);
        if (newRel != null) {
            newRel.setProperties(this.securityContext, properties);
            TransactionCommand.relationshipCreated(this.securityContext.getCachedUser(), newRel);
            newRel.onRelationshipCreation();
            for (Transformation<GraphObject> transformation : StructrApp.getConfiguration().getEntityCreationTransformations(newRel.getClass())) {
                transformation.apply(this.securityContext, newRel);
            }
        }
        this.securityContext.enableModificationOfAccessTime();
        return (R)newRel;
    }

    private <T extends Relation> T instantiate(Class<T> type) {
        try {
            return (T)((Relation)type.newInstance());
        }
        catch (Throwable t) {
            logger.warn("", t);
            return null;
        }
    }
}

