/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.api.NativeResult;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.GraphObjectMap;
import org.structr.core.graph.NodeFactory;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.RelationshipFactory;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.PropertyKey;

public class CypherQueryCommand
extends NodeServiceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)CypherQueryCommand.class.getName());

    public List<GraphObject> execute(String query) throws FrameworkException {
        return this.execute(query, null);
    }

    public List<GraphObject> execute(String query, Map<String, Object> parameters) throws FrameworkException {
        return this.execute(query, parameters, true);
    }

    public List<GraphObject> execute(String query, Map<String, Object> parameters, boolean includeHiddenAndDeleted) throws FrameworkException {
        return this.execute(query, parameters, includeHiddenAndDeleted, false);
    }

    public List<GraphObject> execute(String query, Map<String, Object> parameters, boolean includeHiddenAndDeleted, boolean publicOnly) throws FrameworkException {
        DatabaseService graphDb = (DatabaseService)this.arguments.get("graphDb");
        RelationshipFactory relFactory = new RelationshipFactory(this.securityContext);
        NodeFactory nodeFactory = new NodeFactory(this.securityContext);
        LinkedList<GraphObject> resultList = new LinkedList<GraphObject>();
        if (graphDb != null) {
            try (NativeResult result = graphDb.execute(query, parameters != null ? parameters : Collections.emptyMap());){
                while (result.hasNext()) {
                    Map row = result.next();
                    for (Map.Entry entry : row.entrySet()) {
                        Object value;
                        String key = (String)entry.getKey();
                        Object obj = this.handleObject(nodeFactory, relFactory, key, value = entry.getValue(), includeHiddenAndDeleted, publicOnly, 0);
                        if (obj == null) continue;
                        if (obj instanceof GraphObject) {
                            resultList.add((GraphObject)obj);
                            continue;
                        }
                        if (obj instanceof Collection) {
                            LinkedList nonGraphObjectResult = new LinkedList();
                            for (Object item : (Collection)obj) {
                                if (item instanceof GraphObject) {
                                    resultList.add((GraphObject)item);
                                    continue;
                                }
                                nonGraphObjectResult.add(item);
                            }
                            if (nonGraphObjectResult.isEmpty()) continue;
                            GraphObjectMap graphObject = new GraphObjectMap();
                            graphObject.setProperty((PropertyKey)new GenericProperty(key), nonGraphObjectResult);
                            resultList.add(graphObject);
                            continue;
                        }
                        logger.warn("Unable to handle Cypher query result object of type {}, ignoring.", (Object)obj.getClass().getName());
                    }
                }
            }
        }
        return resultList;
    }

    final Object handleObject(NodeFactory nodeFactory, RelationshipFactory relFactory, String key, Object value, boolean includeHiddenAndDeleted, boolean publicOnly, int level) throws FrameworkException {
        GraphObjectMap graphObject = null;
        if (value instanceof Node) {
            graphObject = (GraphObjectMap)nodeFactory.instantiate((Node)value, includeHiddenAndDeleted, publicOnly);
        } else if (value instanceof Relationship) {
            graphObject = (GraphObjectMap)relFactory.instantiate((Relationship)value);
        } else if (value instanceof Map) {
            Map valueMap = (Map)value;
            graphObject = new GraphObjectMap();
            for (Map.Entry valueEntry : valueMap.entrySet()) {
                String valueKey = (String)valueEntry.getKey();
                Object valueValue = valueEntry.getValue();
                graphObject.setProperty(new GenericProperty(valueKey), this.handleObject(nodeFactory, relFactory, valueKey, valueValue, includeHiddenAndDeleted, publicOnly, level + 1));
            }
        } else {
            if (value instanceof Collection) {
                Collection valueCollection = (Collection)value;
                LinkedList<Object> collection = new LinkedList<Object>();
                for (Object valueEntry : valueCollection) {
                    collection.add(this.handleObject(nodeFactory, relFactory, null, valueEntry, includeHiddenAndDeleted, publicOnly, level + 1));
                }
                return collection;
            }
            if (level == 0) {
                graphObject = new GraphObjectMap();
                graphObject.setProperty(new GenericProperty(key), value);
            } else {
                return value;
            }
        }
        return graphObject;
    }
}

