/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.NotFoundException;
import org.structr.common.error.ErrorBuffer;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.TransactionCommand;

public class DeleteNodeCommand
extends NodeServiceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)DeleteNodeCommand.class.getName());
    private final Set<NodeInterface> deletedNodes = new HashSet<NodeInterface>();

    public void execute(NodeInterface node) {
        this.doDeleteNode(node);
        this.deletedNodes.clear();
    }

    private AbstractNode doDeleteNode(NodeInterface node) {
        try {
            if (!this.deletedNodes.contains(node) && node.getUuid() == null) {
                logger.warn("Will not delete node which has no UUID, dumping stack.");
                Thread.dumpStack();
                return null;
            }
        }
        catch (IllegalStateException ise) {
            logger.warn("Trying to delete a node which is already deleted", (Object)ise.getMessage());
            return null;
        }
        catch (NotFoundException ise) {
            // empty catch block
        }
        this.deletedNodes.add(node);
        App app = StructrApp.getInstance(this.securityContext);
        try {
            int cascadeDelete;
            LinkedList<Object> nodesToCheckAfterDeletion = new LinkedList<Object>();
            for (AbstractRelationship abstractRelationship : node.getOutgoingRelationships()) {
                if (abstractRelationship == null) continue;
                cascadeDelete = abstractRelationship.cascadeDelete();
                Object endNode = abstractRelationship.getTargetNode();
                if ((cascadeDelete & 4) == 4) {
                    nodesToCheckAfterDeletion.add(endNode);
                }
                if (this.deletedNodes.contains(endNode) || (cascadeDelete & 1) != 1) continue;
                endNode.removeFromIndex();
                this.doDeleteNode((NodeInterface)endNode);
            }
            for (AbstractRelationship abstractRelationship : node.getIncomingRelationships()) {
                if (abstractRelationship == null) continue;
                cascadeDelete = abstractRelationship.cascadeDelete();
                Object startNode = abstractRelationship.getSourceNode();
                if ((cascadeDelete & 4) == 4) {
                    nodesToCheckAfterDeletion.add(startNode);
                }
                if (this.deletedNodes.contains(startNode) || (cascadeDelete & 2) != 2) continue;
                startNode.removeFromIndex();
                this.doDeleteNode((NodeInterface)startNode);
            }
            node.onNodeDeletion();
            for (AbstractRelationship abstractRelationship : node.getRelationships()) {
                if (abstractRelationship == null) continue;
                app.delete(abstractRelationship);
            }
            node.removeFromIndex();
            TransactionCommand.nodeDeleted(this.securityContext.getCachedUser(), node);
            node.getNode().delete();
            for (NodeInterface nodeInterface : nodesToCheckAfterDeletion) {
                ErrorBuffer errorBuffer = new ErrorBuffer();
                if (this.deletedNodes.contains(nodeInterface) || nodeInterface.isValid(errorBuffer)) continue;
                nodeInterface.removeFromIndex();
                this.doDeleteNode(nodeInterface);
            }
        }
        catch (Throwable t) {
            logger.debug("Exception while deleting node: {}", (Object)node);
        }
        return null;
    }
}

