/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.structr.api.config.Settings;
import org.structr.api.graph.RelationshipType;
import org.structr.common.AccessPathCache;
import org.structr.common.SecurityContext;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Principal;
import org.structr.core.graph.ModificationEvent;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;

public class GraphObjectModificationState
implements ModificationEvent {
    private static final Set<String> hiddenPropertiesInAuditLog = new HashSet<String>(Arrays.asList("id", "type", "sessionIds", "localStorage", "salt", "password"));
    public static final int STATE_DELETED = 1;
    public static final int STATE_MODIFIED = 2;
    public static final int STATE_CREATED = 4;
    public static final int STATE_DELETED_PASSIVELY = 8;
    public static final int STATE_OWNER_MODIFIED = 16;
    public static final int STATE_SECURITY_MODIFIED = 32;
    public static final int STATE_LOCATION_MODIFIED = 64;
    public static final int STATE_PROPAGATING_MODIFICATION = 128;
    public static final int STATE_PROPAGATED_MODIFICATION = 256;
    private final PropertyMap modifiedProperties = new PropertyMap();
    private final PropertyMap removedProperties = new PropertyMap();
    private final PropertyMap newProperties = new PropertyMap();
    private StringBuilder changeLog = null;
    private RelationshipType relType = null;
    private boolean isNode = false;
    private boolean modified = false;
    private GraphObject object = null;
    private String uuid = null;
    private int status = 0;
    private String callbackId = null;

    @Override
    public String getCallbackId() {
        return this.callbackId;
    }

    public void setCallbackId(String callbackId) {
        this.callbackId = callbackId;
    }

    public GraphObjectModificationState(GraphObject object) {
        this.object = object;
        this.isNode = object instanceof NodeInterface;
        if (!this.isNode) {
            this.relType = ((RelationshipInterface)object).getRelType();
        }
        this.uuid = object.getUuid();
        if (((Boolean)Settings.ChangelogEnabled.getValue()).booleanValue()) {
            this.changeLog = new StringBuilder();
        }
    }

    public String toString() {
        return this.object.getClass().getSimpleName() + "(" + this.object + "); " + this.status;
    }

    @Override
    public String getChangeLog() {
        if (this.changeLog != null) {
            return this.changeLog.toString();
        }
        return null;
    }

    public void propagatedModification() {
        int statusBefore = this.status;
        this.status |= 0x100;
        if (this.status != statusBefore) {
            this.modified = true;
        }
    }

    public void modifyLocation() {
        int statusBefore = this.status;
        this.status |= 0xC0;
        if (this.status != statusBefore) {
            this.modified = true;
        }
    }

    public void modifySecurity() {
        int statusBefore = this.status;
        this.status |= 0xA0;
        if (this.status != statusBefore) {
            this.modified = true;
        }
    }

    public void modifyOwner() {
        int statusBefore = this.status;
        this.status |= 0x90;
        if (this.status != statusBefore) {
            this.modified = true;
        }
    }

    public void create() {
        int statusBefore = this.status;
        this.status |= 0x84;
        if (this.status != statusBefore) {
            this.modified = true;
        }
        this.updateCache();
    }

    public void modify(Principal user, PropertyKey key, Object previousValue, Object newValue) {
        int statusBefore = this.status;
        this.status |= 0x82;
        if (key != null) {
            this.removedProperties.put(key, previousValue);
        }
        if (this.status != statusBefore) {
            if (key != null) {
                this.modifiedProperties.put(key, newValue);
                this.updateChangeLog(user, Verb.change, key, previousValue, newValue);
            }
            this.modified = true;
        } else if (key != null) {
            this.newProperties.put(key, newValue);
            this.updateChangeLog(user, Verb.change, key, previousValue, newValue);
        }
        if (key == null && previousValue == null && newValue == null) {
            this.updateCache();
        }
    }

    public void delete(boolean passive) {
        int statusBefore = this.status;
        if (passive) {
            this.status |= 8;
        }
        this.status |= 1;
        if (this.status != statusBefore) {
            for (PropertyKey key : this.object.getPropertyKeys("public")) {
                this.removedProperties.put(key, this.object.getProperty(key));
            }
            this.modified = true;
        }
        this.updateCache();
    }

    private void updateCache() {
        if (this.uuid != null) {
            AccessPathCache.invalidateForId(this.uuid);
        }
        if (this.relType != null) {
            AccessPathCache.invalidateForRelType(this.relType.name());
        }
    }

    public boolean isPassivelyDeleted() {
        return (this.status & 8) == 8;
    }

    public boolean doInnerCallback(ModificationQueue modificationQueue, SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        Set<AbstractNode> nodes;
        boolean valid = true;
        if ((this.status & 0x80) == 128 && this.object instanceof AbstractNode && (nodes = ((AbstractNode)this.object).getNodesForModificationPropagation()) != null) {
            for (AbstractNode node : nodes) {
                modificationQueue.propagatedModification(node);
            }
        }
        switch (this.status & 0xF) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 7: {
                break;
            }
            case 6: {
                valid &= this.object.onCreation(securityContext, errorBuffer);
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                valid &= this.object.onCreation(securityContext, errorBuffer);
                break;
            }
            case 3: {
                valid &= this.object.onDeletion(securityContext, errorBuffer, this.removedProperties);
                break;
            }
            case 2: {
                valid &= this.object.onModification(securityContext, errorBuffer, modificationQueue);
                break;
            }
            case 1: {
                valid &= this.object.onDeletion(securityContext, errorBuffer, this.removedProperties);
                break;
            }
            case 0: {
                break;
            }
        }
        this.modified = false;
        return valid;
    }

    public boolean doValidationAndIndexing(ModificationQueue modificationQueue, SecurityContext securityContext, ErrorBuffer errorBuffer, boolean doValidation) throws FrameworkException {
        boolean valid = true;
        switch (this.status & 0xF) {
            case 2: 
            case 4: 
            case 6: {
                if (doValidation) {
                    valid &= this.object.isValid(errorBuffer);
                }
                this.object.indexPassiveProperties();
                break;
            }
            case 1: {
                this.object.removeFromIndex();
                break;
            }
        }
        return valid;
    }

    public void doOuterCallback(SecurityContext securityContext) {
        if ((this.status & 9) == 0) {
            if ((this.status & 0x100) == 256) {
                this.object.propagatedModification(securityContext);
            }
            if ((this.status & 0x40) == 64) {
                this.object.locationModified(securityContext);
            }
            if ((this.status & 0x20) == 32) {
                this.object.securityModified(securityContext);
            }
            if ((this.status & 0x10) == 16) {
                this.object.ownerModified(securityContext);
            }
        }
        switch (this.status & 0xF) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 7: {
                break;
            }
            case 6: {
                this.object.afterCreation(securityContext);
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                this.object.afterCreation(securityContext);
                break;
            }
            case 3: {
                this.object.afterDeletion(securityContext, this.removedProperties);
                break;
            }
            case 2: {
                this.object.afterModification(securityContext);
                break;
            }
            case 1: {
                this.object.afterDeletion(securityContext, this.removedProperties);
                break;
            }
            case 0: {
                break;
            }
        }
    }

    public boolean wasModified() {
        return this.modified;
    }

    public void updateChangeLog(Principal user, Verb verb, PropertyKey key, Object previousValue, Object newValue) {
        String name;
        if (((Boolean)Settings.ChangelogEnabled.getValue()).booleanValue() && this.changeLog != null && key != null && !hiddenPropertiesInAuditLog.contains(name = key.jsonName()) && !key.isUnvalidated() && !key.isReadOnly()) {
            JsonObject obj = new JsonObject();
            obj.add("time", this.toElement(System.currentTimeMillis()));
            obj.add("userId", this.toElement(user.getUuid()));
            obj.add("userName", this.toElement(user.getName()));
            obj.add("verb", this.toElement((Object)verb));
            obj.add("key", this.toElement(key.jsonName()));
            obj.add("prev", this.toElement(previousValue));
            obj.add("val", this.toElement(newValue));
            this.changeLog.append(obj.toString());
            this.changeLog.append("\n");
        }
    }

    public void updateChangeLog(Principal user, Verb verb, String linkType, String linkId, String object, Direction direction) {
        if (((Boolean)Settings.ChangelogEnabled.getValue()).booleanValue() && this.changeLog != null) {
            JsonObject obj = new JsonObject();
            obj.add("time", this.toElement(System.currentTimeMillis()));
            obj.add("userId", this.toElement(user.getUuid()));
            obj.add("userName", this.toElement(user.getName()));
            obj.add("verb", this.toElement((Object)verb));
            obj.add("rel", this.toElement(linkType));
            obj.add("relId", this.toElement(linkId));
            obj.add("relDir", this.toElement((Object)direction));
            obj.add("target", this.toElement(object));
            this.changeLog.append(obj.toString());
            this.changeLog.append("\n");
        }
    }

    public void updateChangeLog(Principal user, Verb verb, String object) {
        if (((Boolean)Settings.ChangelogEnabled.getValue()).booleanValue() && this.changeLog != null) {
            JsonObject obj = new JsonObject();
            obj.add("time", this.toElement(System.currentTimeMillis()));
            if (user != null) {
                obj.add("userId", this.toElement(user.getUuid()));
                obj.add("userName", this.toElement(user.getName()));
            } else {
                obj.add("userId", (JsonElement)JsonNull.INSTANCE);
                obj.add("userName", (JsonElement)JsonNull.INSTANCE);
            }
            obj.add("verb", this.toElement((Object)verb));
            obj.add("target", this.toElement(object));
            this.changeLog.append(obj.toString());
            this.changeLog.append("\n");
        }
    }

    private JsonElement toElement(Object value) {
        if (value != null) {
            if (value instanceof String) {
                return new JsonPrimitive((String)value);
            }
            if (value instanceof Number) {
                return new JsonPrimitive((Number)value);
            }
            if (value instanceof Boolean) {
                return new JsonPrimitive((Boolean)value);
            }
            if (value.getClass().isArray()) {
                Object[] values;
                JsonArray arr = new JsonArray();
                for (Object v : values = (Object[])value) {
                    arr.add(this.toElement(v));
                }
                return arr;
            }
            return new JsonPrimitive(value.toString());
        }
        return JsonNull.INSTANCE;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean isCreated() {
        return (this.status & 4) == 4;
    }

    @Override
    public boolean isModified() {
        return (this.status & 2) == 2;
    }

    @Override
    public boolean isDeleted() {
        return (this.status & 1) == 1;
    }

    @Override
    public GraphObject getGraphObject() {
        return this.object;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public PropertyMap getNewProperties() {
        return this.newProperties;
    }

    @Override
    public PropertyMap getModifiedProperties() {
        return this.modifiedProperties;
    }

    @Override
    public PropertyMap getRemovedProperties() {
        return this.removedProperties;
    }

    @Override
    public Map<String, Object> getData(SecurityContext securityContext) throws FrameworkException {
        return PropertyMap.javaTypeToInputType(securityContext, this.object.getClass(), this.modifiedProperties);
    }

    @Override
    public boolean isNode() {
        return this.isNode;
    }

    @Override
    public RelationshipType getRelationshipType() {
        return this.relType;
    }

    public static enum Direction {
        in,
        out;

    }

    public static enum Verb {
        create,
        change,
        delete,
        link,
        unlink;

    }
}

