/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Iterator;
import java.util.Set;
import org.structr.common.Filter;
import org.structr.common.SecurityContext;

public class IterableFilter<T>
implements Iterable<T> {
    private SecurityContext securityContext = null;
    private Iterator<T> sourceIterator = null;
    private Set<Filter<T>> filters = null;

    public IterableFilter(SecurityContext securityContext, Iterable<T> source, Set<Filter<T>> filters) {
        this.sourceIterator = source.iterator();
        this.filters = filters;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private boolean hasNextCalled = false;
            private T currentElement = null;

            @Override
            public boolean hasNext() {
                do {
                    this.currentElement = IterableFilter.this.sourceIterator.hasNext() ? IterableFilter.this.sourceIterator.next() : null;
                } while (this.currentElement != null && !IterableFilter.this.accept(IterableFilter.this.securityContext, this.currentElement));
                this.hasNextCalled = true;
                return this.currentElement != null;
            }

            @Override
            public T next() {
                if (!this.hasNextCalled) {
                    this.hasNext();
                } else {
                    this.hasNextCalled = false;
                }
                return this.currentElement;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("IterableFilterIterator does not support removal of elements");
            }
        };
    }

    private boolean accept(SecurityContext securityContext, T element) {
        boolean ret = true;
        for (Filter<T> predicate : this.filters) {
            predicate.setSecurityContext(securityContext);
            ret &= predicate.accept(element);
        }
        return ret;
    }
}

