/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.common.AccessControllable;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.relationship.NodeHasLocation;
import org.structr.core.graph.Factory;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.graph.TransactionCommand;

public class NodeFactory<T extends NodeInterface & AccessControllable>
extends Factory<Node, T> {
    private static final Logger logger = LoggerFactory.getLogger((String)NodeFactory.class.getName());

    public NodeFactory(SecurityContext securityContext) {
        super(securityContext);
    }

    public NodeFactory(SecurityContext securityContext, boolean includeDeletedAndHidden, boolean publicOnly) {
        super(securityContext, includeDeletedAndHidden, publicOnly);
    }

    public NodeFactory(SecurityContext securityContext, int pageSize, int page, String offsetId) {
        super(securityContext, pageSize, page, offsetId);
    }

    public NodeFactory(SecurityContext securityContext, boolean includeDeletedAndHidden, boolean publicOnly, int pageSize, int page, String offsetId) {
        super(securityContext, includeDeletedAndHidden, publicOnly, pageSize, page, offsetId);
    }

    @Override
    public T instantiate(Node node) {
        return this.instantiate(node, (Relationship)null);
    }

    @Override
    public T instantiate(Node node, Relationship pathSegment) {
        if (node == null) {
            return null;
        }
        if (TransactionCommand.isDeleted(node)) {
            return this.instantiateWithType(node, (Class<T>)null, pathSegment, false);
        }
        return this.instantiateWithType(node, this.factoryDefinition.determineNodeType(node), pathSegment, false);
    }

    @Override
    public T instantiateWithType(Node node, Class<T> nodeClass, Relationship pathSegment, boolean isCreation) {
        if (nodeClass == null) {
            return null;
        }
        SecurityContext securityContext = this.factoryProfile.getSecurityContext();
        NodeInterface newNode = null;
        try {
            newNode = (NodeInterface)nodeClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException | NoClassDefFoundError itex) {
            newNode = null;
        }
        if (newNode == null) {
            newNode = this.factoryDefinition.createGenericNode();
        }
        newNode.init(this.factoryProfile.getSecurityContext(), node, nodeClass, isCreation);
        newNode.setRawPathSegment(pathSegment);
        newNode.onNodeInstantiation(isCreation);
        if (isCreation || securityContext.isReadable(newNode, this.factoryProfile.includeDeletedAndHidden(), this.factoryProfile.publicOnly())) {
            return (T)newNode;
        }
        return null;
    }

    @Override
    public T instantiate(Node node, boolean includeDeletedAndHidden, boolean publicOnly) throws FrameworkException {
        this.factoryProfile.setIncludeDeletedAndHidden(includeDeletedAndHidden);
        this.factoryProfile.setPublicOnly(publicOnly);
        return this.instantiate(node);
    }

    @Override
    public T instantiateDummy(Node entity, String entityType) throws FrameworkException {
        Map<String, Class<? extends NodeInterface>> entities = StructrApp.getConfiguration().getNodeEntities();
        Class<? extends NodeInterface> nodeClass = entities.get(entityType);
        NodeInterface newNode = null;
        if (nodeClass != null) {
            try {
                newNode = nodeClass.newInstance();
                newNode.init(this.factoryProfile.getSecurityContext(), entity, nodeClass, false);
            }
            catch (IllegalAccessException | InstantiationException itex) {
                logger.warn("", (Throwable)itex);
            }
        }
        return (T)newNode;
    }

    protected List<NodeInterface> getNodesAt(NodeInterface locationNode) {
        LinkedList<NodeInterface> nodes = new LinkedList<NodeInterface>();
        for (RelationshipInterface relationshipInterface : locationNode.getIncomingRelationships(NodeHasLocation.class)) {
            NodeInterface startNode = relationshipInterface.getSourceNode();
            nodes.add(startNode);
            nodes.addAll(this.getNodesAt(startNode));
        }
        return nodes;
    }
}

