/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.List;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.common.AccessControllable;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.core.GraphObject;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.entity.ManyEndpoint;
import org.structr.core.entity.ManyStartpoint;
import org.structr.core.entity.OneEndpoint;
import org.structr.core.entity.OneStartpoint;
import org.structr.core.entity.Principal;
import org.structr.core.entity.Relation;
import org.structr.core.entity.Security;
import org.structr.core.entity.Source;
import org.structr.core.entity.Target;
import org.structr.core.entity.relationship.PrincipalOwnsNode;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.EntityIdProperty;
import org.structr.core.property.Property;
import org.structr.core.property.StartNode;
import org.structr.core.property.StartNodes;
import org.structr.core.property.StringProperty;

public interface NodeInterface
extends GraphObject,
Comparable,
AccessControllable {
    public static final Property<String> name = new StringProperty("name").indexed();
    public static final Property<Boolean> deleted = new BooleanProperty("deleted").indexed();
    public static final Property<Boolean> hidden = new BooleanProperty("hidden").indexed();
    public static final Property<Principal> owner = new StartNode("owner", PrincipalOwnsNode.class);
    public static final Property<String> ownerId = new EntityIdProperty<Principal>("ownerId", owner);
    public static final Property<List<Principal>> grantees = new StartNodes("grantees", Security.class);
    public static final View graphView = new View(NodeInterface.class, "_graph", id, name, type);

    public void init(SecurityContext var1, Node var2, Class var3, boolean var4);

    public void onNodeCreation();

    public void onNodeInstantiation(boolean var1);

    public void onNodeDeletion();

    public Node getNode();

    public String getName();

    public boolean isDeleted();

    public <R extends AbstractRelationship> Iterable<R> getRelationships();

    public <R extends AbstractRelationship> Iterable<R> getRelationshipsAsSuperUser();

    public <R extends AbstractRelationship> Iterable<R> getIncomingRelationships();

    public <R extends AbstractRelationship> Iterable<R> getOutgoingRelationships();

    public <A extends NodeInterface, B extends NodeInterface, S extends Source, T extends Target, R extends Relation<A, B, S, T>> Iterable<R> getRelationships(Class<R> var1);

    public <A extends NodeInterface, B extends NodeInterface, T extends Target, R extends Relation<A, B, OneStartpoint<A>, T>> R getIncomingRelationship(Class<R> var1);

    public <A extends NodeInterface, B extends NodeInterface, T extends Target, R extends Relation<A, B, ManyStartpoint<A>, T>> Iterable<R> getIncomingRelationships(Class<R> var1);

    public <A extends NodeInterface, B extends NodeInterface, S extends Source, R extends Relation<A, B, S, OneEndpoint<B>>> R getOutgoingRelationship(Class<R> var1);

    public <A extends NodeInterface, B extends NodeInterface, S extends Source, R extends Relation<A, B, S, ManyEndpoint<B>>> Iterable<R> getOutgoingRelationships(Class<R> var1);

    public void setRawPathSegment(Relationship var1);

    public Relationship getRawPathSegment();
}

