/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.api.Transaction;
import org.structr.api.config.Settings;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.api.index.Index;
import org.structr.api.service.Command;
import org.structr.api.service.InitializationCallback;
import org.structr.api.service.SingletonService;
import org.structr.api.service.StructrServices;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Services;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.BulkCreateLabelsCommand;
import org.structr.core.graph.BulkRebuildIndexCommand;
import org.structr.core.graph.SyncCommand;
import org.structr.core.graph.Tx;

public class NodeService
implements SingletonService {
    private static final Logger logger = LoggerFactory.getLogger((String)NodeService.class.getName());
    private static final String INITIAL_SEED_FILE = "seed.zip";
    private DatabaseService graphDb = null;
    private Index<Node> nodeIndex = null;
    private Index<Relationship> relIndex = null;
    private String filesPath = null;
    private boolean isInitialized = false;

    public void injectArguments(Command command) {
        if (command != null) {
            command.setArgument("graphDb", (Object)this.graphDb);
            command.setArgument("nodeIndex", this.nodeIndex);
            command.setArgument("relationshipIndex", this.relIndex);
            command.setArgument("filesPath", (Object)this.filesPath);
        }
    }

    public void initialize(StructrServices services) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String databaseDriver = (String)Settings.DatabaseDriver.getValue();
        this.graphDb = (DatabaseService)Class.forName(databaseDriver).newInstance();
        if (this.graphDb != null) {
            this.graphDb.initialize();
            this.filesPath = (String)Settings.FilesPath.getValue();
            File files = new File(this.filesPath);
            if (!files.exists()) {
                files.mkdir();
            }
            logger.info("Database driver loaded.");
            try (Transaction tx = this.graphDb.beginTx();){
                this.nodeIndex = this.graphDb.nodeIndex();
                this.relIndex = this.graphDb.relationshipIndex();
                tx.success();
                this.isInitialized = true;
            }
            catch (Throwable t) {
                logger.warn("Error while initializing indexes.");
            }
            if (this.isInitialized) {
                boolean firstInitialization = this.graphDb.getGlobalProperties().getProperty("initialized") == null;
                boolean isTest = Services.isTesting();
                if (this.graphDb.needsIndexRebuild() || firstInitialization && !isTest) {
                    logger.info("Scheduling index rebuild to happen after startup..");
                    services.registerInitializationCallback(new InitializationCallback(){

                        public void initializationDone() {
                            Services.getInstance().command(SecurityContext.getSuperUserInstance(), BulkRebuildIndexCommand.class).execute(Collections.EMPTY_MAP);
                        }

                        public int priority() {
                            return 10;
                        }
                    });
                    services.registerInitializationCallback(new InitializationCallback(){

                        public void initializationDone() {
                            Services.getInstance().command(SecurityContext.getSuperUserInstance(), BulkCreateLabelsCommand.class).execute(Collections.EMPTY_MAP);
                            NodeService.this.graphDb.getGlobalProperties().setProperty("initialized", (Object)true);
                        }

                        public int priority() {
                            return 20;
                        }
                    });
                }
            }
        }
    }

    public void initialized() {
        String basePath = Settings.getBasePath();
        if (StringUtils.isEmpty((String)basePath)) {
            basePath = ".";
        }
        this.importSeedFile(basePath);
    }

    public void shutdown() {
        if (this.isRunning()) {
            logger.info("Shutting down graph database service");
            this.graphDb.shutdown();
            this.graphDb = null;
            this.isInitialized = false;
        }
    }

    public String getName() {
        return NodeService.class.getSimpleName();
    }

    public DatabaseService getGraphDb() {
        return this.graphDb;
    }

    public boolean isRunning() {
        return this.graphDb != null && this.isInitialized;
    }

    public boolean isVital() {
        return true;
    }

    public Index<Node> getNodeIndex() {
        return this.nodeIndex;
    }

    public Index<Relationship> getRelationshipIndex() {
        return this.relIndex;
    }

    private void importSeedFile(String basePath) {
        File seedFile = new File(Settings.trim((String)basePath) + "/" + INITIAL_SEED_FILE);
        if (seedFile.exists()) {
            boolean hasApplicationNodes = false;
            try (Tx tx2 = StructrApp.getInstance().tx();){
                Iterator allNodes = this.graphDb.getAllNodes().iterator();
                String idName = GraphObject.id.dbName();
                while (allNodes.hasNext()) {
                    if (!((Node)allNodes.next()).hasProperty(idName)) continue;
                    hasApplicationNodes = true;
                    break;
                }
                tx2.success();
            }
            catch (FrameworkException tx2) {
                // empty catch block
            }
            if (!hasApplicationNodes) {
                logger.info("Found initial seed file and no application nodes, applying initial seed..");
                try {
                    SyncCommand.importFromFile(this.graphDb, SecurityContext.getSuperUserInstance(), seedFile.getAbsoluteFile().getAbsolutePath(), false);
                }
                catch (FrameworkException fex) {
                    logger.warn("Unable to import initial seed file.", (Throwable)fex);
                }
            }
        }
    }

    public String getModuleName() {
        return "core";
    }
}

