/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.io.IOException;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.service.Command;
import org.structr.common.Filter;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.BulkGraphOperation;
import org.structr.core.graph.NodeService;
import org.structr.core.graph.StructrTransaction;
import org.structr.core.graph.Tx;
import org.structr.util.Writable;

public abstract class NodeServiceCommand
extends Command {
    private static final Logger logger = LoggerFactory.getLogger((String)NodeServiceCommand.class.getName());
    private static final ArrayBlockingQueue<String> uuidQueue = new ArrayBlockingQueue(100000);
    protected SecurityContext securityContext = null;
    private Writable logWritable = null;

    public Class getServiceClass() {
        return NodeService.class;
    }

    public void initialized() {
        this.securityContext = (SecurityContext)this.getArgument("securityContext");
    }

    public <T> long bulkGraphOperation(SecurityContext securityContext, Iterator<T> iterator, long commitCount, String description, BulkGraphOperation<T> operation) {
        return this.bulkGraphOperation(securityContext, iterator, commitCount, description, operation, true);
    }

    public <T> long bulkGraphOperation(SecurityContext securityContext, Iterator<T> iterator, long commitCount, String description, BulkGraphOperation<T> operation, boolean validation) {
        Predicate<Long> condition = operation.getCondition();
        App app = StructrApp.getInstance(securityContext);
        boolean doValidation = operation.doValidation();
        boolean doCallbacks = operation.doCallbacks();
        boolean doNotifications = operation.doNotifications();
        long objectCount = 0L;
        boolean active = true;
        while (active) {
            active = false;
            try (Tx tx = app.tx(doValidation, doCallbacks, doNotifications);){
                while (iterator.hasNext() && (condition == null || condition.accept((Object)objectCount))) {
                    T node = iterator.next();
                    active = true;
                    try {
                        operation.handleGraphObject(securityContext, node);
                    }
                    catch (Throwable t) {
                        operation.handleThrowable(securityContext, t, node);
                    }
                    if (++objectCount % commitCount != 0L) continue;
                    break;
                }
                tx.success();
            }
            catch (Throwable t) {
                operation.handleTransactionFailure(securityContext, t);
            }
            if (description == null) continue;
            this.info("{}: {} objects processed", description, objectCount);
        }
        return objectCount;
    }

    public void bulkTransaction(SecurityContext securityContext, long commitCount, StructrTransaction transaction, Predicate<Long> stopCondition) throws FrameworkException {
        App app = StructrApp.getInstance(securityContext);
        AtomicLong objectCount = new AtomicLong(0L);
        if (stopCondition instanceof Filter) {
            ((Filter)stopCondition).setSecurityContext(securityContext);
        }
        while (!stopCondition.accept((Object)objectCount.get())) {
            Tx tx = app.tx();
            Throwable throwable = null;
            try {
                long loopCount = 0L;
                while (loopCount++ < commitCount && !stopCondition.accept((Object)objectCount.get())) {
                    transaction.execute();
                    objectCount.incrementAndGet();
                }
                tx.success();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
    }

    public static String getNextUuid() {
        String uuid = null;
        while ((uuid = uuidQueue.poll()) == null) {
        }
        return uuid;
    }

    public void setLogBuffer(Writable writable) {
        this.logWritable = writable;
    }

    protected void info(String msg, Object ... data) {
        logger.info(msg, data);
        this.duplicateLogToConsole(msg, data);
    }

    protected void warn(String msg, Object ... data) {
        logger.warn(msg, data);
        this.duplicateLogToConsole(msg, data);
    }

    protected void duplicateLogToConsole(String msg, Object ... data) {
        if (this.logWritable != null) {
            String logMessage = msg;
            for (Object obj : data) {
                if (obj == null) continue;
                logMessage = logMessage.replaceFirst("\\{\\}", obj.toString());
            }
            try {
                this.logWritable.println(logMessage);
                this.logWritable.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        Thread uuidProducer = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            uuidQueue.put(StringUtils.replace((String)UUID.randomUUID().toString(), (String)"-", (String)""));
                        }
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                    break;
                }
            }
        }, "UuidProducerThread");
        uuidProducer.setDaemon(true);
        uuidProducer.start();
    }
}

