/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import org.structr.api.Transaction;
import org.structr.core.TransactionSource;

public class TransactionReference
implements Transaction {
    private TransactionSource source = null;
    private Transaction tx = null;
    private int referenceCount = 0;
    private boolean successful = false;

    public TransactionReference(Transaction tx) {
        this.tx = tx;
    }

    public boolean isToplevel() {
        return this.referenceCount == 1;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void begin() {
        ++this.referenceCount;
    }

    public void end() {
        --this.referenceCount;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public void setSource(TransactionSource source) {
        this.source = source;
    }

    public TransactionSource getSource() {
        return this.source;
    }

    public void failure() {
        if (this.tx != null) {
            this.tx.failure();
            this.successful = false;
        }
    }

    public void success() {
        if (this.tx != null) {
            this.tx.success();
            this.successful = true;
        }
    }

    public void close() {
        if (--this.referenceCount == 0 && this.tx != null) {
            if (!this.successful) {
                this.tx.failure();
            }
            this.tx.close();
        }
    }
}

