/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.structr.api.RetryException;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.StructrTransactionListener;
import org.structr.core.TransactionSource;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.ModificationEvent;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.graph.TransactionCommand;

public class Tx
implements AutoCloseable {
    private final AtomicBoolean guard = new AtomicBoolean(false);
    private SecurityContext securityContext = null;
    private boolean success = false;
    private boolean doValidation = true;
    private boolean doCallbacks = true;
    private boolean doNotifications = true;
    private TransactionCommand cmd = null;
    private StructrApp app = null;

    public Tx(SecurityContext securityContext, StructrApp app) {
        this(securityContext, app, true, true);
    }

    public Tx(SecurityContext securityContext, StructrApp app, boolean doValidation, boolean doCallbacks) {
        this(securityContext, app, doValidation, doCallbacks, securityContext == null ? true : securityContext.isDoTransactionNotifications());
    }

    public Tx(SecurityContext securityContext, StructrApp app, boolean doValidation, boolean doCallbacks, boolean doNotifications) {
        this.securityContext = securityContext;
        this.doNotifications = doNotifications;
        this.doValidation = doValidation;
        this.doCallbacks = doCallbacks;
        this.app = app;
    }

    public Tx begin() {
        this.cmd = this.app.command(TransactionCommand.class).beginTx();
        return this;
    }

    public void success() throws FrameworkException {
        this.cmd.commitTx(this.doValidation);
        this.success = true;
    }

    @Override
    public void close() throws FrameworkException {
        ModificationQueue modificationQueue = this.cmd.finishTx();
        if (this.success && this.guard.compareAndSet(false, true)) {
            boolean retry = true;
            while (retry) {
                retry = false;
                try {
                    Tx tx = this.begin();
                    Throwable throwable = null;
                    try {
                        if (this.doCallbacks && modificationQueue != null) {
                            modificationQueue.doOuterCallbacks(this.securityContext);
                            if (this.securityContext == null ? this.doNotifications : this.doNotifications && this.securityContext.isDoTransactionNotifications()) {
                                Collection<ModificationEvent> modificationEvents = modificationQueue.getModificationEvents();
                                for (StructrTransactionListener listener : TransactionCommand.getTransactionListeners()) {
                                    listener.afterCommit(this.securityContext, modificationEvents, this.cmd.getSource());
                                }
                            }
                            modificationQueue.updateChangelog();
                            modificationQueue.clear();
                        }
                        tx.success();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tx.close();
                    }
                }
                catch (RetryException rex) {
                    retry = true;
                }
            }
            this.guard.set(false);
        }
    }

    public void setSource(TransactionSource source) {
        this.cmd.setSource(source);
    }
}

