/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph.search;

import org.structr.api.search.Occurrence;
import org.structr.api.search.SpatialQuery;
import org.structr.core.GraphObject;
import org.structr.core.graph.search.SearchAttribute;

public class DistanceSearchAttribute
extends SearchAttribute
implements SpatialQuery {
    private boolean needsGeocoding = true;
    private Double[] coords = null;
    private Double distance = null;
    private String street = null;
    private String house = null;
    private String postalCode = null;
    private String city = null;
    private String state = null;
    private String country = null;

    public DistanceSearchAttribute(Double latitude, Double longitude, Double distance, Occurrence occur) {
        super(occur);
        this.coords = new Double[]{latitude, longitude};
        this.distance = distance;
        this.needsGeocoding = false;
    }

    public DistanceSearchAttribute(String street, String house, String postalCode, String city, String state, String country, Double distance, Occurrence occur) {
        super(occur);
        this.street = street;
        this.house = house;
        this.postalCode = postalCode;
        this.city = city;
        this.state = state;
        this.country = country;
        this.distance = distance;
    }

    @Override
    public String toString() {
        return "DistanceSearchAttribute(" + this.street + ", " + this.house + ", " + this.postalCode + ", " + this.city + ", " + this.state + ", " + this.country + ", " + this.distance + ")";
    }

    @Override
    public Double getValue() {
        return this.distance;
    }

    public void setDistance(Double distance) {
        this.distance = distance;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getHouse() {
        return this.house;
    }

    public void setHouse(String house) {
        this.house = house;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public boolean needsGeocding() {
        return this.needsGeocoding;
    }

    public boolean isExactMatch() {
        return true;
    }

    @Override
    public boolean includeInResult(GraphObject entity) {
        return true;
    }

    public void setCoords(Double[] coords) {
        this.coords = coords;
    }

    public Class getQueryType() {
        return SpatialQuery.class;
    }

    public Double[] getCoords() {
        return this.coords;
    }

    public Double getDistance() {
        return this.distance;
    }
}

