/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph.search;

import org.structr.api.search.Occurrence;
import org.structr.api.search.RangeQuery;
import org.structr.core.GraphObject;
import org.structr.core.graph.search.SearchAttribute;
import org.structr.core.property.PropertyKey;

public class RangeSearchAttribute<T>
extends SearchAttribute<T>
implements RangeQuery {
    private PropertyKey<T> searchKey = null;
    private T rangeStart = null;
    private T rangeEnd = null;

    public RangeSearchAttribute(PropertyKey<T> searchKey, T rangeStart, T rangeEnd, Occurrence occur) {
        super(occur);
        this.searchKey = searchKey;
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
    }

    @Override
    public String toString() {
        return "RangeSearchAttribute()";
    }

    @Override
    public PropertyKey getKey() {
        return this.searchKey;
    }

    @Override
    public T getValue() {
        return null;
    }

    public boolean isExactMatch() {
        return true;
    }

    @Override
    public boolean includeInResult(GraphObject entity) {
        T value = entity.getProperty(this.searchKey);
        if (value != null && value instanceof Comparable && this.rangeStart instanceof Comparable && this.rangeEnd instanceof Comparable) {
            Comparable cv = (Comparable)value;
            Comparable cs = (Comparable)this.rangeStart;
            Comparable ce = (Comparable)this.rangeEnd;
            return cs.compareTo(cv) <= 0 && ce.compareTo(cv) >= 0;
        }
        return false;
    }

    public T getRangeStart() {
        return this.rangeStart;
    }

    public T getRangeEnd() {
        return this.rangeEnd;
    }

    public Class getQueryType() {
        return RangeQuery.class;
    }
}

