/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph.search;

import java.util.LinkedHashSet;
import java.util.Set;
import org.structr.api.Predicate;
import org.structr.api.search.Occurrence;
import org.structr.api.search.QueryPredicate;
import org.structr.api.search.SortType;
import org.structr.core.GraphObject;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.property.PropertyKey;

public abstract class SearchAttribute<T>
extends NodeAttribute<T>
implements Predicate<GraphObject>,
QueryPredicate {
    public static final String WILDCARD = "*";
    private Set<GraphObject> result = new LinkedHashSet<GraphObject>();
    private Occurrence occur = null;
    private PropertyKey sortKey = null;
    private boolean sortDescending = false;

    public abstract boolean includeInResult(GraphObject var1);

    public SearchAttribute() {
        this(null, null);
    }

    public SearchAttribute(Occurrence occur) {
        this(occur, null, null);
    }

    public SearchAttribute(PropertyKey<T> key, T value) {
        this(null, key, value);
    }

    public SearchAttribute(Occurrence occur, PropertyKey<T> key, T value) {
        super(key, value);
        this.occur = occur;
    }

    public void setResult(Set<GraphObject> result) {
        this.result = result;
    }

    public Set<GraphObject> getResult() {
        return this.result;
    }

    public void addToResult(GraphObject graphObject) {
        this.result.add(graphObject);
    }

    public void addToResult(Set<GraphObject> list) {
        this.result.addAll(list);
    }

    public void setExactMatch(boolean exact) {
    }

    public void setSortKey(PropertyKey sortKey) {
        this.sortKey = sortKey;
    }

    public void sortDescending(boolean sortDescending) {
        this.sortDescending = sortDescending;
    }

    public boolean accept(GraphObject obj) {
        return this.includeInResult(obj);
    }

    public Occurrence getOccurrence() {
        return this.occur;
    }

    public String getName() {
        return this.getKey().dbName();
    }

    public Class getType() {
        PropertyKey key = this.getKey();
        if (key != null) {
            return key.valueType();
        }
        return null;
    }

    public String getSortKey() {
        if (this.sortKey != null) {
            return this.sortKey.dbName();
        }
        return "name";
    }

    public SortType getSortType() {
        if (this.sortKey != null) {
            return this.sortKey.getSortType();
        }
        return SortType.Default;
    }

    public boolean sortDescending() {
        return this.sortDescending;
    }
}

