/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph.search;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.search.Occurrence;
import org.structr.api.search.TypeQuery;
import org.structr.core.GraphObject;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Relation;
import org.structr.core.graph.search.PropertySearchAttribute;
import org.structr.core.graph.search.SearchCommand;

public class TypeSearchAttribute<S extends GraphObject>
extends PropertySearchAttribute<String>
implements TypeQuery {
    private static final Logger logger = LoggerFactory.getLogger((String)TypeSearchAttribute.class.getName());
    private Set<String> types = null;
    private Class sourceType = null;
    private Class targetType = null;

    public TypeSearchAttribute(Class<S> type, Occurrence occur, boolean isExactMatch) {
        super(AbstractNode.type, null, occur, isExactMatch);
        if (Relation.class.isAssignableFrom(type)) {
            try {
                Relation rel = (Relation)type.newInstance();
                this.setValue(rel.name());
                this.sourceType = rel.getSourceType();
                this.targetType = rel.getTargetType();
            }
            catch (Throwable t) {
                logger.warn("", t);
            }
        } else {
            this.setValue(type.getSimpleName());
        }
        this.types = SearchCommand.getAllSubtypesAsStringSet(type.getSimpleName());
    }

    @Override
    public String toString() {
        return "TypeSearchAttribute(" + super.toString() + ")";
    }

    @Override
    public Class getQueryType() {
        return TypeQuery.class;
    }

    @Override
    public boolean includeInResult(GraphObject entity) {
        String nodeValue = (String)entity.getProperty(this.getKey());
        Occurrence occur = this.getOccurrence();
        boolean isOfType = this.types.contains(nodeValue);
        if (occur.equals((Object)Occurrence.FORBIDDEN)) {
            return !isOfType;
        }
        return isOfType;
    }

    public Class getSourceType() {
        return this.sourceType;
    }

    public Class getTargetType() {
        return this.targetType;
    }
}

