/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.graph.search;

import org.apache.commons.lang3.StringUtils;
import org.structr.api.search.Occurrence;
import org.structr.api.search.UuidQuery;
import org.structr.core.GraphObject;
import org.structr.core.graph.search.SearchAttribute;

public class UuidSearchAttribute
extends SearchAttribute<String>
implements UuidQuery {
    public UuidSearchAttribute(String value, Occurrence occur) {
        super(occur, GraphObject.id, value);
    }

    @Override
    public String toString() {
        return "UuidSearchAttribute(" + super.toString() + ")";
    }

    public Class getQueryType() {
        return UuidQuery.class;
    }

    public boolean isExactMatch() {
        return true;
    }

    @Override
    public void setExactMatch(boolean exact) {
    }

    @Override
    public boolean includeInResult(GraphObject entity) {
        String nodeValue = (String)entity.getProperty(this.getKey());
        Occurrence occur = this.getOccurrence();
        String searchValue = (String)this.getValue();
        return !(occur.equals((Object)Occurrence.FORBIDDEN) ? nodeValue != null && this.compare(nodeValue, searchValue) == 0 : (nodeValue != null ? this.compare(nodeValue, searchValue) != 0 : searchValue != null && StringUtils.isNotBlank((CharSequence)searchValue)));
    }

    public String getUuid() {
        return (String)this.getValue();
    }

    private int compare(String nodeValue, String searchValue) {
        return nodeValue.compareTo(searchValue);
    }
}

