/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.notion;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.EntityAndPropertiesContainer;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.TypeToken;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.Principal;
import org.structr.core.entity.Relation;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.search.SearchCommand;
import org.structr.core.notion.DeserializationStrategy;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.RelationProperty;

public class IdDeserializationStrategy<S, T extends NodeInterface>
implements DeserializationStrategy<S, T> {
    private static final Logger logger = LoggerFactory.getLogger((String)IdDeserializationStrategy.class.getName());
    protected RelationProperty<S> relationProperty = null;

    @Override
    public void setRelationProperty(RelationProperty<S> parentProperty) {
        this.relationProperty = parentProperty;
    }

    @Override
    public T deserialize(SecurityContext securityContext, Class<T> type, S source, Object context) throws FrameworkException {
        App app = StructrApp.getInstance(securityContext);
        if (source != null) {
            if (source instanceof Map) {
                Map properties = (Map)source;
                Class actualType = type;
                if (actualType != null && actualType.isInterface() && properties.containsKey(NodeInterface.type.jsonName())) {
                    String typeFromInput = properties.get(NodeInterface.type.jsonName()).toString();
                    actualType = StructrApp.getConfiguration().getNodeEntityClass(typeFromInput);
                    if (actualType == null) {
                        actualType = type;
                    }
                }
                PropertyMap convertedProperties = PropertyMap.inputTypeToJavaType(securityContext, actualType, properties);
                Set<PropertyKey> allProperties = StructrApp.getConfiguration().getPropertySet(type, "all");
                HashMap<String, Object> foreignProps = new HashMap<String, Object>();
                NodeInterface relatedNode = null;
                if (convertedProperties.containsKey(GraphObject.id)) {
                    relatedNode = app.getNodeById(convertedProperties.get(GraphObject.id));
                    if (relatedNode != null) {
                        if (!SearchCommand.isTypeAssignableFromOtherType(type, relatedNode.getClass())) {
                            throw new FrameworkException(422, "Node type mismatch", new TypeToken(type.getSimpleName(), null, type.getSimpleName()));
                        }
                        for (PropertyKey key : convertedProperties.keySet()) {
                            if (key.isUnique() || key.isCompound() || this.isIdentifying(actualType, key) || allProperties.contains(key)) continue;
                            foreignProps.put(key.jsonName(), properties.get(key.jsonName()));
                        }
                        convertedProperties.remove(GraphObject.id);
                    }
                } else {
                    PropertyMap uniqueKeyValues = new PropertyMap();
                    for (PropertyKey key : convertedProperties.keySet()) {
                        if (key.isUnique() || key.isCompound() || this.isIdentifying(actualType, key)) {
                            uniqueKeyValues.put(key, convertedProperties.get(key));
                            continue;
                        }
                        if (allProperties.contains(key)) continue;
                        foreignProps.put(key.jsonName(), properties.get(key.jsonName()));
                    }
                    if (!uniqueKeyValues.isEmpty()) {
                        List possibleResults = app.nodeQuery(type).and(uniqueKeyValues).getAsList();
                        int num = possibleResults.size();
                        switch (num) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                relatedNode = (NodeInterface)possibleResults.get(0);
                                break;
                            }
                            default: {
                                throw new FrameworkException(422, this.concat("Unable to resolve related node of type ", type.getSimpleName(), ", ambiguous result: found ", num, " nodes for the given property set."));
                            }
                        }
                    }
                }
                if (relatedNode == null) {
                    if (this.relationProperty != null) {
                        Relation relation = this.relationProperty.getRelation();
                        if (this.relationProperty.doAutocreate()) {
                            return app.create(type, convertedProperties);
                        }
                        throw new FrameworkException(422, this.concat("Cannot create ", relation.getOtherType(type).getSimpleName(), ": no matching ", type.getSimpleName(), " found for the given property set ", convertedProperties, " and autoCreate has a value of ", this.relationProperty.getAutocreateFlagName()));
                    }
                    throw new FrameworkException(500, this.concat("Unable to resolve related node of type ", type.getSimpleName(), ", no relation defined."));
                }
                if (!convertedProperties.isEmpty()) {
                    this.setProperties(securityContext, relatedNode, convertedProperties);
                }
                if (foreignProps.isEmpty()) {
                    return (T)relatedNode;
                }
                return (T)new EntityAndPropertiesContainer(relatedNode, foreignProps);
            }
            if (type.isAssignableFrom(source.getClass())) {
                return (T)((NodeInterface)source);
            }
            NodeInterface obj = app.getNodeById(source.toString());
            if (obj != null && !type.isAssignableFrom(obj.getClass())) {
                throw new FrameworkException(422, "Node type mismatch", new TypeToken(obj.getClass().getSimpleName(), null, type.getSimpleName()));
            }
            return (T)obj;
        }
        return null;
    }

    private String concat(Object ... values) {
        StringBuilder buf = new StringBuilder(values.length * 20);
        for (Object value : values) {
            buf.append(value);
        }
        return buf.toString();
    }

    private boolean isIdentifying(Class actualType, PropertyKey key) {
        return Principal.class.isAssignableFrom(actualType) && (Principal.name.equals(key) || Principal.eMail.equals(key));
    }
}

