/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.notion;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.Adapter;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.graph.NodeInterface;
import org.structr.core.notion.DeserializationStrategy;
import org.structr.core.notion.SerializationStrategy;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.RelationProperty;

public abstract class Notion<S extends NodeInterface, T> {
    private static final Logger logger = LoggerFactory.getLogger((String)Notion.class.getName());
    protected DeserializationStrategy<T, S> deserializationStrategy = null;
    protected SerializationStrategy<S, T> serializationStrategy = null;
    protected SecurityContext securityContext = null;
    protected String idProperty = null;
    protected Class<S> type = null;

    public Notion(SerializationStrategy serializationStrategy, DeserializationStrategy deserializationStrategy) {
        this.serializationStrategy = serializationStrategy;
        this.deserializationStrategy = deserializationStrategy;
    }

    public abstract PropertyKey<T> getPrimaryPropertyKey();

    public void setRelationProperty(RelationProperty<T> propertyKey) {
        this.serializationStrategy.setRelationProperty(propertyKey);
        this.deserializationStrategy.setRelationProperty(propertyKey);
    }

    public Adapter<S, T> getAdapterForGetter(final SecurityContext securityContext) {
        this.securityContext = securityContext;
        return new NotionAdapter<S, T>(){

            @Override
            public T adapt(S s) throws FrameworkException {
                return Notion.this.serializationStrategy.serialize(securityContext, Notion.this.type, s);
            }
        };
    }

    public Adapter<T, S> getAdapterForSetter(final SecurityContext securityContext) {
        return new NotionAdapter<T, S>(){

            @Override
            public S adapt(T s) throws FrameworkException {
                if (s instanceof Collection) {
                    throw new ClassCastException("Invalid source type.");
                }
                return Notion.this.deserializationStrategy.deserialize(securityContext, Notion.this.type, s, this.context);
            }
        };
    }

    public Adapter<List<S>, List<T>> getCollectionAdapterForGetter(final SecurityContext securityContext) {
        return new NotionAdapter<List<S>, List<T>>(){

            @Override
            public List<T> adapt(List<S> s) throws FrameworkException {
                LinkedList list = new LinkedList();
                for (NodeInterface o : s) {
                    list.add(Notion.this.serializationStrategy.serialize(securityContext, Notion.this.type, o));
                }
                return list;
            }
        };
    }

    public Adapter<List<T>, List<S>> getCollectionAdapterForSetter(final SecurityContext securityContext) {
        return new NotionAdapter<List<T>, List<S>>(){

            @Override
            public List<S> adapt(List<T> s) throws FrameworkException {
                if (s == null) {
                    return Collections.EMPTY_LIST;
                }
                LinkedList list = new LinkedList();
                for (Object t : s) {
                    list.add(Notion.this.deserializationStrategy.deserialize(securityContext, Notion.this.type, t, this.context));
                }
                return list;
            }
        };
    }

    public PropertyConverter<T, S> getEntityConverter(SecurityContext securityContext) {
        return new PropertyConverter<T, S>(securityContext, null){

            @Override
            public T revert(S source) throws FrameworkException {
                NotionAdapter adapter = (NotionAdapter)Notion.this.getAdapterForGetter(this.securityContext);
                adapter.setContext(this.context);
                return adapter.adapt(source);
            }

            @Override
            public S convert(T source) throws FrameworkException {
                NotionAdapter adapter = (NotionAdapter)Notion.this.getAdapterForSetter(this.securityContext);
                adapter.setContext(this.context);
                return (NodeInterface)adapter.adapt(source);
            }
        };
    }

    public PropertyConverter<List<T>, List<S>> getCollectionConverter(SecurityContext securityContext) {
        return new PropertyConverter<List<T>, List<S>>(securityContext, null){

            @Override
            public List<T> revert(List<S> source) throws FrameworkException {
                NotionAdapter adapter = (NotionAdapter)Notion.this.getCollectionAdapterForGetter(this.securityContext);
                adapter.setContext(this.context);
                return (List)adapter.adapt(source);
            }

            @Override
            public List<S> convert(List<T> source) throws FrameworkException {
                NotionAdapter adapter = (NotionAdapter)Notion.this.getCollectionAdapterForSetter(this.securityContext);
                adapter.setContext(this.context);
                return (List)adapter.adapt(source);
            }
        };
    }

    public void setType(Class<S> type) {
        this.type = type;
    }

    public void setIdProperty(String idProperty) {
        this.idProperty = idProperty;
    }

    public static <S, T> List<T> convertList(List<S> source, Adapter<S, T> adapter) {
        LinkedList<T> result = new LinkedList<T>();
        for (S s : source) {
            try {
                result.add(adapter.adapt(s));
            }
            catch (FrameworkException fex) {
                logger.warn("Error in iterable adapter", (Throwable)fex);
            }
        }
        return result;
    }

    public static abstract class NotionAdapter<S, T>
    implements Adapter<S, T> {
        protected Object context = null;

        public void setContext(Object context) {
            this.context = context;
        }
    }
}

