/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.notion;

import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.PropertiesNotFoundToken;
import org.structr.common.error.TypeToken;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.NodeInterface;
import org.structr.core.notion.DeserializationStrategy;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.RelationProperty;

public class TypeAndPropertySetDeserializationStrategy<S, T extends NodeInterface>
implements DeserializationStrategy<S, T> {
    private static final Logger logger = LoggerFactory.getLogger((String)TypeAndPropertySetDeserializationStrategy.class.getName());
    protected RelationProperty relationProperty = null;
    protected PropertyKey[] propertyKeys = null;
    protected boolean createIfNotExisting = false;

    public TypeAndPropertySetDeserializationStrategy(PropertyKey ... propertyKeys) {
        this(false, propertyKeys);
    }

    public TypeAndPropertySetDeserializationStrategy(boolean createIfNotExisting, PropertyKey ... propertyKeys) {
        this.createIfNotExisting = createIfNotExisting;
        this.propertyKeys = propertyKeys;
    }

    @Override
    public void setRelationProperty(RelationProperty<S> relationProperty) {
        this.relationProperty = relationProperty;
    }

    @Override
    public T deserialize(SecurityContext securityContext, Class<T> type, S source, Object context) throws FrameworkException {
        if (source instanceof Map) {
            PropertyMap attributes = PropertyMap.inputTypeToJavaType(securityContext, type, (Map)source);
            return this.deserialize(securityContext, type, attributes);
        }
        if (source != null && type.isAssignableFrom(source.getClass())) {
            return (T)((NodeInterface)source);
        }
        if (source != null && source instanceof String && Pattern.matches("[a-fA-F0-9]{32}", (String)source)) {
            return (T)this.getTypedResult(new Result<NodeInterface>(StructrApp.getInstance(securityContext).getNodeById((String)source), false), type);
        }
        return null;
    }

    private T deserialize(SecurityContext securityContext, Class<T> type, PropertyMap attributes) throws FrameworkException {
        App app = StructrApp.getInstance(securityContext);
        if (attributes != null) {
            Result<NodeInterface> result = Result.EMPTY_RESULT;
            if (attributes.containsKey(GraphObject.id)) {
                result = new Result<NodeInterface>(app.getNodeById(attributes.get(GraphObject.id)), false);
            } else {
                boolean attributesComplete = true;
                for (PropertyKey key : this.propertyKeys) {
                    attributesComplete &= attributes.containsKey(key);
                }
                if (attributesComplete) {
                    PropertyMap searchAttributes = new PropertyMap();
                    for (PropertyKey key : attributes.keySet()) {
                        if (key.relatedType() != null) continue;
                        searchAttributes.put(key, attributes.get(key));
                    }
                    result = app.nodeQuery(type).and(searchAttributes).getResult();
                }
            }
            String errorMessage = null;
            int size = result.size();
            switch (size) {
                case 0: {
                    T newNode;
                    if (this.createIfNotExisting && (newNode = app.create(type, attributes)) != null) {
                        return newNode;
                    }
                    errorMessage = "No node found for the given properties and auto-creation not enabled";
                    break;
                }
                case 1: {
                    NodeInterface relatedNode = this.getTypedResult(result, type);
                    if (!attributes.isEmpty()) {
                        this.setProperties(securityContext, relatedNode, attributes);
                    }
                    return (T)relatedNode;
                }
                default: {
                    errorMessage = "Found " + size + " nodes for given type and properties, property set is ambiguous";
                    logger.error("This is often due to wrong modeling, or you should consider creating a uniquness constraint for " + type.getName(), (Object)size);
                }
            }
            throw new FrameworkException(404, errorMessage, new PropertiesNotFoundToken(type.getSimpleName(), null, attributes));
        }
        return null;
    }

    private T getTypedResult(Result<T> result, Class<T> type) throws FrameworkException {
        T obj = result.get(0);
        if (!type.isAssignableFrom(obj.getClass())) {
            throw new FrameworkException(422, "Node type mismatch", new TypeToken(type.getSimpleName(), null, type.getSimpleName()));
        }
        return (T)((NodeInterface)result.get(0));
    }
}

